
## 7.3 Results

Our implementation of GIB's cardplay when declarer is based on the ideas described above.

(As a defender, a direct Monte Carlo approach appears preferable because enough information is typically available about declarer's hand to make the double-dummy assumption reasonably valid.) The implementation is fast enough to conform to the time requirements placed on a production program (roughly one CPU minute to play each deal).

Evaluating the impact of these ideas on GIB's cardplay is difficult, since declarer play is already the strongest aspect of its game. In extended matches between the two versions of GIB, the approach based on the ideas described here beats the Monte-Carlo based version by approximately 0.1 IMPs/deal, but there is a great deal of noise in the data because most of the swings correspond to differences in bidding or defensive play. It is possible to remove some of these differences artificially (requiring the bidding to be identical both times the deal is played, for example), but defensive differences remain. Nevertheless, GIB is currently a strong enough player that the 0.1 imps/deal difference is significant.

The situation on problem deals, such as those from the par contests or from the Gitelman

| Source           |
|------------------|
| BM level 1       |
| level 2          |
| level 3          |
| level 4          |
| level 5          |
| 1998 par contest |
| 1990 par contest |

sets, is much clearer. In addition, many of the deals that GIB gets "wrong" are in fact deals that GIB plays correctly but that the problem composers play incorrectly (Gitelman or, in the case of the par contests, Swiss bridge expert Pietro Bernasconi). In the following table, we have been generous with all parties, deeming a line to be correct if it is not clearly inferior to another. Let me point out that the designers of the problems are attempting to construct deals where there is a unique solution (the "answer" to the test they are posing the solver), so that a deal with multiple solutions is in fact one that the composer has already misanalyzed.

The rows are in order of increasing difficulty; it was universally felt among the human competitors that the deals in the 1990 par contest were far more difficult than those in 198. The columns are as follows:
is the source from which the problems were obtained. is the number of problems available from this particular source.

| So urce   |
|-----------|
| Size      |
| B         |
| GI BMC    |
| GI BSW O  |
| composer  |
| ambiguous |

gives the number of problems solved correctly by Bridge Baron 6.

gives the number solved correctly by GIB using a Monte Carlo approach. gives the number solved correctly by GIB using SWO and achievable sets.

| GIBMC   |    |          |          |            |    |
|---------|----|----------|----------|------------|----|
| size    | B  | GI BSW O | composer | ambig uous |    |
| 36      | 16 | 31       | 36       | 35         | 0  |
| 36      | 8  | 23       | 34       | 34         |    |
| 36      | 2  | 12       | 34       | 34         | 2  |
| 36      | 21 | 31       | 34       | 4          |    |
| 1       |    |          |          |            |    |
| 36      | 4  | 13       | 28       | 34         | 5  |
| 12      |    |          |          |            |    |
| 1 2     | 0  | 5        | 11       | 2          |    |
| 18      | 0  | 8        | 14       | 17         | C  |

gives the number solved correctly by the composer (in that the intended solution was the best one available).

gives the number misanalyzed by the composer (in that multiple solutions exist).