Definition 2.2.2 Given an interval-valued game (G,pi,s,ev), we introduce a function evc : G → [0, 1] defined recursively by

$$\mathtt{ev}_{c}(p)={\left\{\begin{array}{l l}{\mathtt{ev}\,(p\,),}&{{\qquad}{i f\,\mathtt{ev}\,(p)\in[0,1\,]\,;}}\\ {\max_{p^{\prime}\,\in\,s\,(p)}\mathtt{ev}_{c}(p^{\prime}\,),}&{{\quad}{i f\,\mathtt{ev}\,(p)=\max;}}\\ {\min_{p^{\prime}\,\in\,s\,(p)}\mathtt{ev}_{c}(p^{\prime}\,),}&{{\quad}{i f\,\mathtt{ev}\,(p)=\min.}}\end{array}\right.}$$

The value of (G, p,, s, ev) is defined to be evc(p,).

To evaluate a position in a game, we can use the well-known minimax procedure:
Algorithm 2.2.3 (Minimax) For a game ( G, p, s, ev) and a position p ∈ G, to compute eeee (p):
if ev(p) ∈ [0, 1] return ev(p)
if ev(p) = max return max p ' ∈ s(p) minimax(p ′ )
if ev(p) = min return minp'Es(p) minimax(p')
There are two ways in which the above algorithm is typically extended. The first involves the introduction of transposition tables; we will assume that a new entry is added to the transposition table T whenever one is computed.  (A modification to cache only selected results is straightforward.) The second involves the introduction of a β pruning. Incorporating these ideas gives us the algorithm at the top of the next page.

Each entry in the transposition table consists of a position p, the current cutoffs [ x, y ],
and the computed value v. Note the need to include information about the cutoffs in the transposition table itself, since the validity of any particular entry depends on the cutoffs in question.

As an example, suppose that the value of some node is in fact 1 (a win for the maximizer) but that when the node is evaluated with cutoffs of [0, 0.5] a value of 0.5 is returned (indicating a draw) because the maximizer has an obviously drawing line. It is clear that this value is only accurate for the given cutoffs; wider cutoffs will lead to a different answer.

In general, the upper cutoff y is the currently smallest value assigned to a minimizing node; the minimizer can do at least this well in that he can force a value of y or lower.

Similarly, x is the currently greatest value assigned to a maximizing node. These cutoff values are updated as the algorithm is invoked recursively in the lines responsible for setting vnew, the value assigned to a child of the current position p.

Proposition 2.2.4  Suppose that v = αβ(p,[x,y]) for each entry (p,[x,y],v) in T.  Then if evc(p) E [x,y], the value returned by Algorithm 2.2.5 is evc(p).

口