Algorithm 2.2.5 (a-β pruning with transposition tables) Given an interval-valued game ( G, p I , s, ev), a position p ∈ G, cutoffs [ x, y ] ⊆ [ 0, 1] and a transposition table T
consisting of triples ( p, [ a, b ], v ) with p ∈ G and a ≤ b, v ∈ [ 0, 1 ], to compute αβ ( p, [ x, y ]):
if there is an entry (p, [x,y], z) in T return z if ev(p) E [0, 1] then vans = ev(p)
if ev(p) = max then Vans := 0 for each p' E s(p) do vnew = αβ(p', [max(vans: x), y])
if vnew ≥ y then T := T U (p, [x, y], vnew )
return vnew if vnew > vans then vans = vnew if ev(p) = min then Vans := 1 for each p' E s(p) do vnew = αβ(p', [x, min(vans, y)])
if vnew ≤ x then T := T U (p, [x, y]; vnew )
return vnew if vnew < vans then vans = vnew T := T U (p, [x, y]; vans)
return vans

## 2.3 Partitions

We are now in a position to present our new ideas. We begin by formalizing the idea of a position that can reach a known winning position or one that can reach only known losing ones.

Definition 2.3.1 Given an interval-valued game (G, p, s, ev) and a set of positions S ⊆ G, we will say that the set of positions that can reach S is the set of all p for which s(p)∩ S ̸= ∅.

This set will be denoted R n ( S ). The set of positions constrained to reach S is the set of all p for which s(p) ⊆ S, and is denoted C (S).

These definitions should match our intuition; the set of positions that can reach a set S
is indeed the set of positions p for which some element of S is an immediate successor of p, so that s(p) N S ̸= ∅. Similarly, a position p is constrained to reach S if every immediate successor of p is in S, so that s(p) C S.

Unfortunately, it may not be feasible to construct the R 0 and C 0 operators explicitly; there may be no concise representation of the set of all positions that can reach S. In practice, this will be reflected in the fact that the data structures being used to describe