
## 3.1.2 L O Cal P Olicies

In the original MDP, behaviours are modelled at only two levels: the primitive action level, and the plan level (policy).  We would like to consider policies that select other more refined policies and so on, down a number of abstraction levels. The idea is to form intermediate-level abstract policies as policies defined over a local region of the state space, having a certain terminating condition, and can be invoked and executed just like primitive actions (Forestier & Varaiya, 1978; Sutton et al., 1999). Definition 1 (Local policy). A local policy is a tuple π = 〈 S, D, β, σ 〉 where:
- S is the set of applicable states.

- D is the set of destination states. β : D → (0,1) is the stopping probabilities such that β(d) = 1, ∀ d ∈ D \ S.

- σ : S × A → [0,1] is the selection function. Given the current state s, σ(s, a) is the probability that the action a is selected by the policy 7r at state s.
The set S models the local region over which the policy is applicable. S will be called the set of applicable states, since the policy can start from any state in S. We shall assume here that S is discrete, and thus shall not be concerned with the technical details in generalising the AHMM formulation to the continuous state space case. The stopping condition of the policy is modelled by a set of possible destination states D and a set of positive stopping probabilities β( d ), d ∈ D where β ( d ) is the probability that the policy will terminate when the current state is d. It is possible to allow the policy to stop at some state outside of S, however, for all d E D \ S we enforce the condition that β( d ) = 1, i.e., d is a terminal destination state. Sometimes, we might only want to consider policies with deterministic stopping condition. In that case, every destination is a terminal destination: Vd E D, β ( d ) = 1. Thus, for a deterministically terminating policy, we can ignore the redundant parameter β , and need only specify the set of destinations D .

Given a starting state s E S, a local policy as defined above generates a Markov sequence of states according to its transition model. Each time a destination state d ∈ D is reached, the process stops with probability β ( d ). Since the process starts from within S, but terminates only in one of the states in D, the destination states play the role of the possible exits out of the local region S of the state space.

When we want to make clear which policy is currently being referred to, we shall use the subscripted notations S π , D π , βπ , σπ to denote the elements of the policy π .

Fig. 2 illustrates how a local policy π can be visualised. Fig. 2(a) shows the set of applicable states S, the set of destinations D, and a chain starting within S and terminating in D . The Bayesian network in Fig. 2(b) provides the detailed view of the chain from start to finish. The Bayesian network in Fig. 2(c) is the abstract view of the chain where we are only interested in its starting and stopping states.

## 3.1.3 Abstract Policies

The local policy as defined above selects among the set of primitive actions. Similarly, but more generally, we can define higher level policies that select among a set of other policies.