Using the AMM as a model of plan execution thus allows us to blur the difference between planning and re-planning. At the same time, it moves from the recognition of a classical plan towards the recognition of the agent's intention.  Most of the existing framework for probabilistic plan recognition does not explicitly represent the current state, and thus, the relationship between states and the adoption and termination of current plans is ignored (Goldman et al., 1999). 5 Thus, it would be impossible to tell if the current plan has failed and the new plan is an attempt to recover from this failure, or the current plan has succeeded and the new plan is part of a new higher level goal.

A more expressive language for describing abstract probabilistic plan is the Hierarchical Abstract Machines (HAM) proposed in (Parr & Russell, 1997; Parr, 1998). In a HAM, the abstract policy is replaced by a stochastic finite automaton, which can call other machines at the lower level. Our abstract policies can be written down as machines of this type. Such a machine would choose one of the machines correspond to the policies at the lower level and then go back to the start state after the called machines have terminated. The HAM
framework allows for machines with arbitrary finite number of machine states and transition probabilities, 6 thus can readily represent more complex plans such as concatenation of policies, alternative policy paths, etc.  It is possible to represent each machine in HAM as a policy in our AMM, however with the cost of augmenting the state space to include the machine states of all the machines in the current call stack. Thus, the size of the AMM's new state space would be exponential with respect to the number of nested levels in the HAM's call stack. While this shows in theory the expressiveness of HAM and our policy hierarchy is the same, performing policy recognition on the HAM-equivalent policy hierarchy is probably unwise since the state space becomes exponentially large after the conversion. A better idea would be to represent the internal state of each machine as a variable in a DBN and perform inference on this DBN structure directly.

The AMM is also closely related to a model for probabilistic plan recognition called the Probabilistic State-Dependent Grammar (PSDG), independently proposed in (Pynadath, 1999; Pynadath & Wellman, 2000). The PSDG can be described as the Probabilistic Context Free Grammar (PCFG) (Jelinek, Lafferty, & Mercer, 1992), augmented with a state space, and a state transition probability table for each terminal symbol of the PCFG. In addition, the probability of each production rule is made state dependent. As a result, the terminal symbol now acts like primitive actions and the non-terminal symbol chooses its expansion depending on the current state. Interestingly, the PSDG is directly related to the HAM language described above, similar to the way production-rule grammars are related to finite automata.  Given a PSDG, we can convert it to an equivalent HAM by constructing a machine for each non-terminating symbol, and modelling the production rules for each nn-terminating symbol by the automaton.

Our policy hierarchy is equivalent to a special class of PSDG where only production rules of the form X → YX and X → 0 are allowed. The former rule models the adoption of a lower level policy Y by a higher level policy X , while the latter models the termination of a policy X. The PSDG model considered in (Pynadath, 1999; Pynadath & Wellman, 200) allows for more general rules of the form X → Y 1 . . . Y m X 1 i.e., the recursion symbol