
## 4.2 Conditional Independence In The Current Time-Slice

The above discussion identifies a tractable case for the AHMM, but it requires the knowledge of the entire history of the state and the policy ending status variables. In this subsection, we focus on the conditional independence property of the nodes in the current time-slice:
st, π p , . . , π j k .  Since these nodes will make up the belief state of any future inference algorithm for our AHMM, any independence properties among these variables, if exploited, can provide a more compact representation of the belief state and reduce the inference complexity.

Due to the way policies are invoked in the AMM, we can make an intuitive remark that the higher level policies can only influence what happens at the lower level through the current level. More precisely, for a level k policy π f , if we know its starting state, the course of its execution is fully determined, where being determined here means without influence from what is happening at the higher levels. Furthermore, if we also know how long the policy has been executed, or equivalently its starting time, the current state of its execution is also determined. Thus, the higher level policies can only influence the current state of execution of πξ either through its starting state or starting time. In other words, if we know p together with its starting time and starting state, then the current higher level policies are completely independent of the current lower level policies and the current state.  The theorem 1 below formally states this in a precise form. Note that the condition obtained is the strictest: if one of the three conditional variables is unknown, there are examples of AMMs in which the higher level policies can influence the lower level ones.

Theorem 1. Let τ k and b be two random variables representing the starting time and the starting state, respectively, of the current level-k policy π ℓ : τ ℓ = max{t' < t | e ℓ , = T} and t = s,k. Let π λ k = {π k + 1 , . . ,π k } denote the set of current policies from level k + 1 up to K , and πξ k = { st, πξ, . . , πξ− 1 } denote the set of current policies from level k − 1 down to 0 together with the current state. We have:

$$\pi_{\,\,t}^{\,\geq k}\,\perp\pi_{\,\,t}^{\,<k}\,\vert\,\pi_{\,\,t}^{\,k}\,,\,b_{t}^{k}\,,\,\tau_{\,\,t}^{\,k}$$

(7)
Proof. We sketch here an intuitive proof of this theorem through the use of the Bayesian network manipulation rules for context-specific independence which have been discussed in 4.1.1 and 4.1.2. An alternative proof that does not use CSI can be found in (Bui et al.,
200).

We first note that the theorem is not obvious by looking at the full DBN in Fig. 8.

Therefore, we shall proceed by modifying the network structure in the context that we know Tf At time , all the policies at level k and below must terminate: e , k = T for all l < k.

Thus we can remove all the links from these policies to the new policies at time T t + 1.

On the other hand, from time τ t + 1 until the current time t, all the policies at level k and above must not terminate: e f = F for all l ≥ k, r f + 1 ≤ t ′ < t . Thus we can group all the policies at level l ≥ k between time τ k + 1 and t into one node representing the current policy at level l.

These two network manipulation steps result in a network with the structure shown in Fig. 10. Once the modified network structure is obtained, we can observe that π λ k and