In order to apply RB-SIS to the AHMM, the main problem is to identify which variables should be used as the Rao-Blackwellising variables and should still be sampled, with the remaining variables being marginalised analytically. The key to choosing the Rao- Blackwellising variables, as we have shown in 2.5, is so that if those variables can be observed, the Rao-Blackwellised belief state becomes tractable. In subsection 5.1, we have demonstrated that if the state history § and the terminating status history Î t can be observed then the belief state has a simple network structure and can be updated with constant average complexity. Thus, ( s t, l t ) can be used conveniently as the Rao-Blackwellising variable r . Note that the variables I t are the context variables which help to simplify the network structure of the AHMM, while the state variables š t help to make the remaining network singly-connected so that exact inference can operate efficiently (see subsection 4.1.3).

## 5.2.1  Rb-Sis For Ahmm

We now discuss the specific application of RB-SIS to the problem of belief state updating and policy recognition in the AHMM. Our main objective is to use RB-SIS to estimate the conditional probability of the policy currently being executed at level- k given the current sequence of observations Pr( π t + 1 | δ t ).

Mapping the RB-SIS general framework in subsection 2.5 to the AHMM structure, the set of all current variables x t is now the set of current policies, terminating status nodes, and the current state: x t = ( π f l t , s t , l t ). The probability under estimation Pr( π f +1 | δ t ) can be viewed as an expectation by letting f( π f l t ) = Pr( π f + 1 | π f l t , s t , l t ) so that:

$$\bar{f}=\sum_{\pi_{t}^{a_{t}^{\dagger1}\,,\,s_{t},\,l_{t}}}\mathrm{Pr}(\pi_{t+1}^{k}|\pi_{t}^{a l l},\,s_{t},l_{t})\,\mathrm{Pr}(\pi_{t}^{a l l},\,s_{t},l_{t}|\tilde{o}_{t})=\mathrm{Pr}(\pi_{t+1}^{k}\mid\tilde{o}_{t})$$

Using RB-SIS to estimate this expectation, we shall split x t into two sets of variables:
the set of RB variables r t = ( s t, l t ), and the set of remaining variables z t = π i l  which is the set of all the current policies. The functional h, which depends only on the RB variables and is obtained from f by integrating out the remaining variables (Eq. (5)), now has the form :

$$h(\tilde{r}_{t})=h(\tilde{s}_{t},\tilde{l}_{t})=\sum_{\pi_{t}^{jl}}\Pr\bigl{(}\pi_{t+1}^{h}\mid\pi_{t}^{jl},s_{t},l_{t}\bigr{)}\Pr\bigl{(}\pi_{t}^{jl}\mid\tilde{s}_{t},\tilde{l}_{t},\tilde{o}_{t}\bigr{)}=\Pr\bigl{(}\pi_{t+1}^{h}\mid\tilde{s}_{t},\tilde{l}_{t}\bigr{)}\tag{11}$$

which is the marginal C t +1 ( π t +1 ) from the belief ain at time t + 1.

The RB belief state, which is the belief state of the AHMM when the RB variables are known, becomes:

$${\cal R}_{t}={\rm Pr}(\pi_{t}^{\,all},s_{t},l_{t},o_{t}\,|\,\,\tilde{s}_{t-1},\tilde{l}_{t-1},\tilde{o}_{t-1}\,)={\rm Pr}(\pi_{t}^{\,all},s_{t},l_{t},o_{t}\,|\,\,\tilde{s}_{t-1},\tilde{l}_{t-1}\,)\tag{12}$$

and is identical to the special belief state B t discussed in subsection 5.1, except a minor modification to attach the observation variable ot.

From (11) and (12), both the h function and the RB belief state can be computed very efficiently using the exact inference techniques described in 5.1. Thus RB-SIS can be implemented efficiently with minimal overhead in exact inference.

The main RB-SIS algorithm for the AHMM is given in Fig. 14. Note that we only need to sample the RB variables št and lt. For each sample i, in addition to the weights w (i),