

![0_image_0.png](0_image_0.png)

We implement the RB-SIS method (with re-sampling) and use the policy hierarchy specification and the simulated observation sequence as input to the algorithm. In a typical run, the algorithm can return the probability of the main building exit, the next wing exit, and the next room-door that the agent is currently heading to. An example track is shown in Fig. 17. As the observations about the track arrive over time, the prediction probability distribution of which main building exit the track is heading to is shown in Fig. 18.

To illustrate the advantage of RB-SIS, we also implement an SIS method without Rao-
Blackwellisation (LW with ER and re-sampling (Kanazawa et al., 1995)) and compare the performance of the two algorithms. We run the two algorithms using different sample population sizes to obtain their performance profiles. For a given sample size N, the standard deviation ( σ( N )) over 50 runs in the estimated probabilities of the top-level policies is used as the measure of expected error in the probability estimates. We also record the average time taken in each update iteration.

Fig. 19(a) plots the standard deviation of the two algorithms for different sample sizes.

The behaviour of the error follows closely the theoretical curve σ(N) = c/√N, or σ 2 (N) =
c 2 /N 1 with c SI S ≈ 0.26 and c RB - SI S ≈ 0.055. As expected, for the same number of samples, the RB-SIS algorithm delivers much better accuracy.

Fig. 19(b) plots the average CPU time ( T ) taken in each iteration versus the sample size. As expected, T(N) is linear to N, with the RB-SIS taking about twice longer due to the overhead in updating the RB belief state while processing each sample.

Fig. 19(c) plots the actual CPU time taken versus the expected error for the two algorithms. It shows that for the same CPU time spent, the RB-SIS method still significantly reduces the error in the probability estimates.

Note that for each algorithm, the quantity η = σ 2 ( N ) T ( N ) is approximately constant since the dependency on N cancels one another out. Thus, this constant can be used as an efficiency coefficient to measure the performance of the sampling algorithm independent of the number of samples. For example, if an algorithm has a twice smaller coefficient, it can deliver the same accuracy with half CPU time, or half the variance for the same CPU time. Fig. 20 plots the efficiency coefficients for both SIS and RB-SIS, with η SIS ≈ 0.0018 and