Approximative inference algorithms (Pearl, 1987; York, 1992; Henrion, 1988; Fung & Chang, 1989; Shachter & Peot, 1989) compute only an approximation of the required probability, usually obtained either through "forward" sampling (Henrion, 1988; Fung & Chang, 1989; Shachter & Peot, 1989) (a variance of Bayesian Importance Sampling (Geweke, 1989)), or through Gibbs (Monte-Carlo Markov-Chain) sampling (Pearl, 1987; York, 1992).  These algorithms have the advantages of simple implementation, can be applied to all types of network, and can trade off the accuracy in the estimates for computation resources. It is known that exact inference in BN is NP-hard with respect to the network size (Cooper, 1990), while approximate inference, although scales well with the network size, is NP-hard with respect to the hard-bound accuracy of the estimates (Dagum & Luby, 1993). In the light of these theoretical results, approximate inference can be useful in large networks when exact computation is intractable, but a certain degree of error in the probability estimate can be tolerated by the application.

## 2.2 Dynamic Bayesian Networks

To model the temporal dynamics of the environment, the Dynamic Bayesian Network
(DBN) (Dean & Kanazawa, 1989; Nicholson & Brady, 1992; Dagum, Galper, & Horvitz, 1992) is a special Bayesian network architecture for representing the evolution of the domain variables over time. A DBN consists of a sequence of time-slices where each time-slice contains a set of variables representing the state of the environment at the current time. A time-slice is in itself a Bayesian network, with the same network structure replicated at each time-slice. The temporal dynamics of the environment is encoded via the network links from one time-slice to the next. In addition, each time-slice can contain observation nodes which model the (possibly noisy) observation about the current state of the environment.

Given a DBN and a sequence of observations, we might want to draw predictions about the future state variables (predicting), or about the unobserved variables in the past (smoothing) (Kjaerulff, 1992).  This problem can be solved using an inference algorithm for Bayesian networks described above. However, if we want to revise the prediction as the observations arrive over time, reapplying the inference algorithm each time the observation sequence changes could be costly, especially as the sequence grows. To avoid this, we need to keep the joint distribution of all the variables in the current time-slice, given the observation sequence up to date. This probability distribution is termed the belief state
(also known as the filtering distribution ) and plays an important role in inferencing in the DN. All existing inference schemes for the DBN involve maintaining and updating the belief state (i.e., filtering). When a new observation is received, the current belief state is rolled over one time-slice ahead following the evolution model, then conditioned on the new observation to obtain the updated belief state.

An obvious problem with this approach is the size of the belief state that we need to maintain.  It has been noted that while the interaction of the variables in the DBN is localised, the variables in the belief state can be highly connected (Boyen & Koller, 1998).

This is because the marginalisation of the past time-slices usually destroys the conditional independence of the current time-slice. When the size of the belief state is large, exact inference methods like (Kjærulff, 1995) is intractable, and it becomes necessary to maintain only an approximation of the actual belief state, either in the form of an approximate