# Efficient Methods For Qualitative Spatial Reasoning

## Jochen Renz

RENZ@DBAI.TUWIEN.AC.AT
Institut für Informationssysteme, Technische Universität Wien Favoritenstr.9, A-1040 Wien, Austria Bernhard Nebel Institut für Informatik, Albert-Ludwigs-Universität Am Flughafen 17, D-79110 Freiburg, Germany NEBEL@INFORMATIK. UNI-FREIBURG. DE

## Abstract

The theoretical properties of qualitative spatial reasoning in the RCC-8 framework have been analyzed extensively. However, no empirical investigation has been made yet. Our experiments show that the adaption of the algorithms used for qualitative temporal reasoning can solve large RCC-8 instances, even if they are in the phase transition region
- provided that one uses the maximal tractable subsets of RCC-8 that have been identified by us. In particular, we demonstrate that the orthogonal combination of heuristic methods is successful in solving almost all apparently hard instances in the phase transition region up to a certain size in reasonable time.

## 1. Introduction

Representing qualitative spatial information and reasoning with such information is an important subproblem in many applications, such as natural language understanding, document interpretation, and geographical information systems. The RCC-8 calculus (Randell, Cui, & Cohn, 1992b) is well suited for representing topological relationships between spatial regions. Inference in the full calculus is, however, NP-hard (Grigni, Papadias, & Papadimitriou, 1995; Renz & Nebel, 1999). While this means that it is unlikely that very large instances can be solved in reasonable time, this result does not rule out the possibility that we can solve instances up to a certain size in reasonable time. Recently, maximal tractable ssent to the speed up backtracking search for the general NP-complete reasoning problem by reducing the search space considerably.

In this paper we address several questions that emerge from previous theoretical results on RCC-8 (Renz & Nebel, 1999; Renz, 1999): Up to which size is it possible to solve instances in reasonable time? Which heuristic is the best? Is it really so much more efficient to use the maximal tractable subsets for solving instances of the NP-complete consistency problem as the theoretical savings given by the smaller branching factors indicate or is this effect out-balanced by the forward-checking power of the interleaved path-consistency computations? This was the case for similar temporal problems (pointisable vs. ORD-Horn relations) (Nebel, 1997). Is it possible to combine the different heuristics in such a way that more instances can be solved in reasonable time than by each heuristic alone?

We treat these questions by randomly generating instances and solving them using different heuristics. In doing so, we are particularly interested in the hardest randomly