one such constraint, the one with the smallest weight. The reason for choosing the relation with the smallest decomposition is that it is expected that forward-checking refines relations with a larger decomposition into relations with a smaller decomposition. This reduces the backtracking effort. For the global strategy, the constrainedness of a constraint xRy is determined by adding the weights of all neighboring relations S,T with xSz and zTy to the weight of R. The idea behind this strategy is that when refining the relation R with the most restricted neighborhood, an inconsistency is detected faster than when refining a relation with a less restricted neighborhood.

In order to evaluate the quality of the different heuristics, we measured the run-time used for solving instances as well as the number of visited nodes in the sear space.  Comparing different approaches by their run-time is often not very reliable as it depends on several factors such as the implementation of the algorithms, the used hardware, or the current load of the used machine which makes results sometimes not reproducible. For this reason, we ran all our run-time experiments on the same machine, a Sun Ultra 1 with 128 MB of main memory. Nevertheless, we suggest to use the run-time results mainly for qualitatively comparing different heuristics and for getting a rough idea of the order of magnitude for which instances can be solved.

In contrast to this, the number of visited nodes for solving an instance with a particular heuristic is always the same on every machine. This allows comparing the path through the ss choices on average. However, this does not take into account the time that is needed to make a choice at a single node. Computing the local constrainedness of a constraint is certainly faster than computing its global constrainedness.  Similarly, computing constrainedness statically should be faster than computing it dynamically. Furthermore, larger instances require more time at the nodes than smaller instances, be it for computing path-consistency or for computing the constrainedness. Taking running-time and the number of visited nodes together gives good indications of the quality of the heuristics.

A further choice we make in evaluating our measurements is that of how to aggregate the measurements of the single instances to a total picture. Some possibilities are to use either the average or different percentiles such as the median, i.e., the 50% percentile. The d% percentile for a value 0 < d < 100 is obtained by sorting the measurements in increasing order and picking the measurement of the d% element, i.e., d% of the values are less than that value. Suppose that most instances have a low value (e.g. running time) and only a few instances have a very large value. Then the average might be larger than the values of almost all instances, while in this case the median is a better indication of the distribution of the values. In this case the 99% percentile, for instance, gives a good indication of the value of the hardest among the "normal" instances.  We have chosen to use the average value when the measurements are well distributed and to use both 50% and 99% percentile when there are only a few exceptional values in the distribution of the measurements.

## 4. Empirical Evaluation Of The Path-Consistency  Algorithm

Since the efficiency of the backtracking algorithm depends on the efficiency of the underlying path-consistency algorithm, we will first compare different implementations of the pathconsistency algorithm. In previous empirical investigations (van Beek & Manchak, 1996) of