reasoning with Allen's interval relations (Allen, 1983), different methods for computing the composition of two relations were evaluated. This was mainly because the full composition table for the interval relations contains 213 x 213 = 67108864 entries, whi was too large at that time to be stored in the main memory. In our setting, we simply use a composition table that specifies the compositions of all RCC-8 relations, which is a 256 × 256 table consuming approximately 128 KB of main memory. This means that the composition of two arbitrary relations is done by a simple table lookup.

Van Beek and Manchak (1996) also studied the effect of weighting the relations in the queue according to their restrictiveness and process the most restricting relation first.

Restrictiveness was measured for each base relation by successively composing the base relation with every possible label, summing up the cardinalities, i.e., the number of base relations contained in the result of the composition, and suitably scaling the result. The reason for doing so is that the most restricting relation restricts the other relations on average most and therefore decreases the probability that they have to be processed again. Restrictiveness of a complex relation was approximated by summing up the restrictiveness of the involved base relations. Van Beek and Manak (1996) found that their method of weighting the triples in the queue is much more efficient than randomly picking an arbitrary triple. Because of the relatively small number of RCC-8 relations, we computed the exact restrictiveness by composing each relation with every other relation and summing up the cardinalities of the resulting compositions. We scaled the result into weights from 1 (the most restricting relation) to 16 (the least restricting relations).

This gives us three different implementations of the path-consistency algorithm. One in which the entries in the queue are not weighted, one with approximated restrictiveness as done by van Beek and Manchak, and one with exact restrictiveness. 5 In order to compare these implementations, we randomly generated instances with 50 to 1,000 regions.  For each value of the average degree ranging from 8.0 stepping with 0.5 to 11.0 we generated 10 different instances. Figure 4 displays the average CPU time of the different methods for applying the path-consistency algorithm to the same generated instances.  It can be seen that the positive effect of using a weighted queue is much greater for our problem than for the temporal problem (about 10x faster than using an ordinary queue without weights compared to only about 2× faster (van Beek & Manak, 1996)). Determining the weights of every relation using their exact restrictiveness does not have much advantage over approximating their restrictiveness using the approach by van Beek and Manchak (1996), however. For our further experiments we always used the "exact weights" method because determining the restrictiveness amounts to just one table lookup.

As mentioned in the previous section, one way of measuring the quality of the heuristics is to count the number of visited nodes in the backtrack search. In our backtracking algorithm, path-consistency is enforced in every visited node. Note that it is not adequate to multiply the average running-time for enforcing path-consistency of an instance of a particular size with the number of visited nodes in order to obtain an approximation of the required running time for that instance. The average running-time for enforcing pathconsistency as given in Figure 4 holds only when all possible paths are entered into the queue at the beginning of the computation (see line 1 of Figure 2). These are the paths