For the runtime studies for H ( n, d, 4.0) we noticed that there are many hard instances for n > 40 (see Figure 8), for n = 80 almost all instances in the phase-transition region are hard (see last column of Table 1). Also, as Table 1 shows, the number of hard instances varies a lot for the different heuristics. Therefore, it is not possible to compare the percentile running times of the different heuristics for n > 40. For n = 80 and d = 14 (see last column of Table 1), for instance, the 50% and 99% percentile element of the C 8 /dynamic/global heuristic is element no.36 and element no.72, while it is element no.141 and element no.280 of the H 8 /dynamic/local heuristic (out of the 500 sorted elements), respectively.

For this reason we show the results only up to a size of n = 40 (see Figure 10). Again, we took the average of the different degrees from d = 10 to d = 15 in order to cover the whole phase-transition region. The order of the run times is the same for different combinations of computing constrainedness: B » B, Cs » Qs, Hs, while Hs is in most cases the fastest. As for the A(n,d,4.0) instances, the run times for dynamic/global were much longer than the other combinations. The 99% percentile run times of the static/global combination and for H s and Q s of the dynamic/local combination are faster than those of the other combinations. Although the median CPU times are about the same as for A(n, d, 4.0) for n < 40, the percentile 99% CPU times are mu longer. As it was already shown in Figure 7 and 8, this is further evidence that there are very hard instances in the phase-transition region of H ( n, d, 4.0).

## 7. Orthogonal Combination Of The Heuristics

In the previous section we studied the quality of different heuristics for solving randomly generated RSAT instances. We found that several instances which are mainly located in the phase-transition region could not be solved by some heuristics within our limit of 10,000 visited nodes in the search space.  Since the different heuristics have a different search space (depending on the split set) and use a different path through the search space (determined by the different possibilities of computing constrainedness), it is possible that instances are hard for some heuristics but easily solvable for other heuristics. Nebel (1997) observed that running different heuristics in parallel can solve more instances of a particular hard set of temporal reasoning instances proposed by van Beek and Manchak (1996) than any single heuristic alone can solve, when using altogether the same number of visited nodes as for each heuristic alone. An open question of Nebel's investigation (Nebel, 1997) was whether this is also the case for the hard instances in the phase-transition region.

In this section we evaluate the power of "orthogonally combining" the different heuristics for solving RSAT instances, i.e., running the different heuristics for each instance in parallel until one of the heuristics solves the instance.  There are different ways for simulating this parallel processing on a single processor machine. One is to use time slicing between the different heuristics, another is to run the heuristics in a fixed or random order until a certain number of nodes in the search space is visited and if unsuccessful try the next heuristic (cf. Huberman, Lukose, & Hogg, 1997).  Which possibility is chosen and with which parameters (e.g., the order in which the heuristics are run and the number of visited nodes which is spent for each heuristic) determines the efficiency of the single processor simulation of the orthogonal combination. In order to find the best parameters, we ran all heuristics using at most 10,000 visited nodes for each heuristic on the set of hard instances