up to which almost all of them, especially those in the phase-transition region, can still be solved in acceptable time. Since many instances of H ( n, d, 4.0) are already too difficult for a size of n = 80 (see Figure 12), we restrict our analysis to the instances of A(n, d, 4.0) and study randomly generated instances with a size of more than n = 100 nodes.

For instances of a large size allowing a maximal number of 10,000 visited nodes in the search space is too much for obtaining an acceptable runtime. 10,000 visited nodes for instances of size n = 100 corresponds to a runtime of more than 10 seconds on a Sun Ultra1, for larger instances it gets much slower. Therefore, we have to restrict the maximal number of visited nodes in order to achieve an acceptable runtime.  Given a multi-processor machine, the different heuristics can be run orthogonally on different processors using the maximal nmber of visited nodes each. If the orthogonal combination of the different heuristics is simulated on a single-processor machine, the maximal number of nodes has to be divided by the number of used heuristics to obtain the available number of visitable nodes for each heuristic. Thus, the more different heuristics we use, the less visitable nodes are available for each heuristic. Therefore, in order to achieve the best performance, we have to find the combination of heuristics that solves most instances within a given number of visitable nodes. The chosen heuristics should not only solve many instances alone, they should also complement each other well, i.e., instances whi cannot be solved by one heuristic should be solvable by the other heuristic.

We started by finding the optimal combination of heuristics for the set of 788 hard instances of A ( n, d, 4.0). From our empirical evaluation given in Section 6 we know how many visited nodes each heuristic needs in order to solve each of the 788 hard instances.

Therefore, we computed the number of solved instances for all 2 20 possible combinations of the heuristics using an increasing maximal number of visitable nodes for all heuristics together. Since we only tried to find the combination which solves the most instances, this can be computed quite fast.  The results are given in Table 3.  They show that a good performance can be obtained with a maximal number of 600 visited nodes. In this case four heuristics were involved, i.e., 150 visitable nodes are spent on each of the four heuristics. Since the same combination of heuristics ( H s /static/global, H s /dynamic/local, Cs/dynamic/local, B/static/local ) is also the best for up to 1,000 visitable nodes, we choose this combination for our further analysis. We choose the order in which they are processed to be 1. Hs /dynamic/local, 2. Hs /static/global, 3. Cs /dynamic/local, 4. B /static/localaccording to their first response behavior given in Table 2. Note that although the two heuristics C 8 /dynamic/local and B/static/local do not show a particularly good performance when running them alone (see Table 2), they seem to best complement the other two heuristics.

What we have to find next is the maximal number of visitable nodes we spend for the heuristics. For this we ran the best performing heuristic ( H s/dynamic/local ) on instances of the phase-transition region of varying sizes. It turned out that for almost all consistent instances the number of visited nodes required for solving them was slightly less than twice the size of the instances while most inconsistent instances are also not path-consistent and, thus, solvable with only one visited node.  Therefore, we ran the four heuristics in the following allowing 2 n visited nodes ea, where n is the size of the instance, i.e., together we allow at most 8n visitable nodes. We randomly generated test instances according to the A(n, d, 4.0) model for a size of n = 110 regions up to a size of n = 500 regions with a step of 10 regions and 100 instances for each size and each average degree ranging from