the size of the search space is the average branching factor b of the search space, i.e., the average number of branches each node in the search space has (a node is a recursive call of CONSISTENCY). Then the average size of the search space can be computed as b(n 2 -n)/2, where ( n ² - n )/2 is the number of constraints which have to be split when n variables are given. For the backtracking algorithm described in Figure 3 the branching factor depends on the average number of relations of the split set S into which a relation has to be split.

The less splits on average the better, i.e., it is to be expected that the efficiency of the backtracking algorithm depends on the split set S and its branching factor. Another factor is how the search space is explored. The backtracking algorithm of Figure 3 offers two possibilities for applying heuristics. One is in line 3 where the next unprocessed constraint can be chosen, the other is in line 5 where the next refinement can be chosen. These two choices influence the search space and the path through the search space.

## 3. Test Instances, Heuristics, And Measurement

There is no previous work on empirical evaluation of algorithms for reasoning with RCC-8 and no benchmark problems are known. Therefore we randomly generated our test instances with a given number of regions n, an average label-size l, and an average degree d of the constraint graph. Further, we used two different sets of relations for generating test instances, the set of all RCC-8 relations and the set of hard RCC-8 relations NPs, i.e., those 76 relations which are not contained in any of the maximal tractable subsets Hs, Cs, or Qs. Based on these sets of relations, we used two models to generate instances, denoted by A(n,d,l) and H(n,d,l). The former model uses all relations to generate instances, the latter only the relations in NP 8 . The instances are generated as follows:

1. A constraint graph with n nodes and an average degree of d for each node is generated.

This is accomplished by selecting nd/2 out of the n(n - 1)/2 possible edges using a uniform distribution.

2. If there is no edge between the ith and j th node, we set M ij = M jj to be the universal relation.

3. Otherwise a non-universal relation is selected according to the parameter l such that the average size of relations for selected edges is . This is accomplished by selecting one of the base relations with uniform distribution and out of the remaining 7 relations each one with probability ( l –1)/7. 3  If this results in an allowed relation (i.e., a relation of NPs for H ( n, d, l ), any RCC-8 relation for A ( n, d, l )), we assign this relation to the edge. Otherwise we repeat the process.
The reason for also generating instances using only relations of NP s  is that we assume that these instances are difficult to solve since every relation has to be split during the backtracking search, even if we use a maximal tractable subclass as the split set. We only generated instances of average label size l = 4.0, since in this case the relations are equally distributed.