This way of generating random instances is very similar to the way random CSP instances over finite domains are usually generated (Gent, MacIntyre, Prosser, Smith, & Walsh, 2001). Achlioptas et al. (1997) found that the standard models for generating random CSP instances over finite domains lead to trivially flawed instances for n → ∞, i.e., instances become locally inconsistent without having to propagate constraints. Since we are using CSP instances over infinite domains, Achlioptas et al.'s result does not necessarily hold for our random instances. We, therefore, analyze in the following whether our instances are also trivially flawed for n -> 00. In order to obtain a CSP over a finite domain, we first have to transform our constraint graph into its dual graph where each of the n(n - 1)/2 edges Mj, of our constraint graph corresponds to a node in the dual graph. Moreover, each of the n variables of the constraint graph corresponds to n - 1 edges in the dual graph, i.e., the dual graph contains n(n - 1) edges and n(n - 1)/2 nodes. In the dual graph, each node corresponds to a variable over the eight-valued domain D = {DC, EC, PO, TPP, TPP-', NTPP, NTPP-', EQ}. Ternary constraints over these variables are imposed by the composition table, i.e., the composition rules M ij

= n(n - 1)(n - 2)/6 connected triples in the dual graph. The must hold for all connected triples of nodes M ij , M ik , M kj of the dual graph ( M ij = M ij for all i, j). There are ( n ) nd/2 unary constraints on overall number of triples in the dual graph is (n(n - 1)/2)
triples in the dual graph the domain of the variables M ij are given, i.e., there are (nd/2)
3 where all nodes are restricted by unary constraints. Therefore, the expected number E n T
of connected triples for which unary constraints are given can be computed as

$$E_{C T}^{n}={\frac{\left(\begin{array}{l}{{n}}\\ {{3}}\end{array}\right)\cdot{\left(\begin{array}{l}{{n}{d}/{2}}\\ {{3}}\end{array}\right)}}{{\left(\begin{array}{l}{{n}{\left({n}-{1}\right)}/{2}}\\ {{3}}\end{array}\right)}}}.$$

For n → ∞ , the expected number of triples E ∞ r tends to d 3 /6. For the instances generated according to the model A(n,d,l), the probability that the unary constraints which are assigned to a triple lead to a local inconsistency is about 0,0036% (only 58,989 out of the 255 3 = 16,581,375 possible assignments are inconsistent). Since one locally inconsistent triple makes the whole instance inconsistent, we are interested in the average degree d for which the expected number E n 7 of locally inconsistent triples is equal to one. For the model A(n, d, l) this occurs for a value of d = 11.90, and E i T = 0.5 for d = 9.44. For n = 100, the expected number of locally inconsistent triples is one for d = 13.98, and E 1 , pp = 0.5 for d = 11.10. For the model H ( n, d, l ), none of the possible assignments of the triples leads to a local inconsistency, i.e., all triples of the randomly generated instances of the H ( n, d, l )
model are locally consistent. 4 This analysis shows that contrary to what Achlioptas et al. found for randomly generated CSP instances over finite domains, the model H ( n, d,l ),
and the model A(n,d,l) for d small do not suffer from trivial local inconsistencies.