We solve the randomly generated instances using the backtracking algorithm described in the previous section. The search space on which backtracking is performed depends on the split set, i.e., the set of sub-relations that is allowed in the decompositions. Choosing the right split-set influences the search noticeably as it influences the average branching factor of the search space.  We choose five different split sets, the three maximal tractable subsets Hs, Qs, and Cs, the set of base relations B and the closure of this set B which consists of 38 relations. These sets have the following branching factors B: 4.0, B: 2.50 ,Hs: 1.438, C s : 1.523, Q s : 1.516. This is, of course, a worst case measure because the interleaved pathconsistency computations reduce the branching factor considerably (Ladkin & Reinefeld, 197).

Apart from the choice of the split set there are other heuristics which influence the efficiency of the search. In general it is the best search strategy to proceed with the constraint with the most constraining relation (line 3 of Figure 3) and the least constraining choice of a sub-relation (line 5 of Figure 3). We investigated two different aspects for choosing the next constraint to be processed (Nebel, 1997).

static/dynamic: Constraints are processed according to a heuristic evaluation of their constrainedness which is determined statically before the backtracking starts or dy -
n mically during the search.

local/global: The evaluation of the constrainedness is based on a local heuristic weight criterion or on a global heuristic criterion (van Beek & Manchak, 1996).

This gives us four possibilities we can combine with the five different split sets, i.e., a total number of 20 different heuristics. The evaluation of constrainedness as well as how relations are decomposed into relations of different split sets depends on the restrictiveness of relations, which is a heuristic criterion (van Beek & Manchak, 1996).  Restrictiveness of a relation is a measure of how a relation restricts its neighborhood. For instance, the universal relation given in a constraint network does not restrict its neighboring relations at all, the result of the composition of any relation with the universal relation is the universal relation. The identity relation, in contrast, restricts its neighborhood a lot. In every triple of variables where one relation is the identity relation, the other two relations must be equal.

Therefore, the universal relation is usually the least restricting relation, while the identity relation is usually the most restricting relation. Restrictiveness of relations is represented as a weight in the range of 1 to 16 assigned to every relation, where 1 is the value of the most and 16 the value of the least restricting relation. We discuss in the following section in detail how the restrictiveness and the weight of a relation is determined.

Given the weights assigned to every relation, we compute decompositions and estimate constrainedness as follows. For ea split set S and for ea RCC-8 relation R we compute the smallest decomposition of R into sub-relations of S, i.e., the decomposition which requires the least number of sub-relations of S . If there is more than one possibility, we choose the decomposition with the least restricting sub-relations. In line 5 of the backtracking algorithm (see Figure 3), the least restricting sub-relation of each decomposition is processed first. For the local strategy, the constrainedness of a constraint is determined by the size of its decomposition (which can be different for every split set) and by its weight. We choose the constraint with the smallest decomposition larger than one and, if there is more than