# Towards Owl-Based Knowledge Representation In Petrology

Alex Shkotin, Vladimir Ryakhovsky, and Dmitry Kudryavtsev Vernadsky State Geological Museum, Russian Academy of Sciences Mokhovaya 11/11, 125009, Moscow, Russia ashkotin@acm.org Abstract. **This paper presents our work on development of OWL-driven**
systems for formal representation and reasoning about terminological knowledge and facts in petrology. The long-term aim of our project is to provide solid foundations for a large-scale integration of **various kinds of** knowledge, including basic terms, rock classification algorithms, findings and reports. We describe three steps we have taken towards that goal here. First, we develop a semi-automated procedure for transforming a database of igneous rock samples to texts in a controlled natural language
(CNL), and then a collection of OWL ontologies. Second, we create an OWL ontology of important petrology terms currently described in natural language thesauri. We describe a prototype of a tool for **collecting**
definitions from domain experts. Third, we present an approach to formalization of current industrial standards for classification of rock samples, which requires linear equations in OWL 2. In conclusion, we discuss a range of opportunities arising from the use of semantic technologies in petrology and outline the future work in this area.

Keywords: **OWL, petrology, controlled natural language,**
formal conceptualization, rock classification, formal theory

## 1 Introduction

Petrology, a branch of geology studying rocks and their formation, plays an important role in describing Earth's crust structure, which is essential for revealing patterns in distribution of mineral resources. Similar to other natural sciences, a wealth of knowledge requiring a proper management (especially with **regard** to consistency) and integration has been accumulated in petrology. These tasks could be approached more efficiently, if the knowledge had been machine processable, in particular, if a *formal theory of petrology* **(i.e. a system of axioms,**
definitions and theorems [11], p.33) had been available. Ontologies, especially OWL ontologies, are well suited for playing the role of a cornerstone **of such**
theory, as they have been remarkably successful in other sciences, e.g., bioinformatics, chemistry, and health care.

This paper describes our steps towards developing a formal theory of petrology. We focus on identifying basic terms, providing definitions to other commonly