The type of learning we consider here is statistical parameter learning applied to logic programs. 1 We assume that facts (unit clauses) in a program are probabilistically true and have a parameterized distribution. 2  Other clauses, non-unit definite clauses, are always true as they encode laws such as "if one has a pair of blood type genes a and b, one's blood type is AB". We call logic programs of this type a parameterized logic program and use for statistical modeling in which ground atoms 3 provable from the program represent our observations such as "one's blood type is AB" and the parameters of the program are inferred by performing ML (maximum likelihood) estimation on the observed atoms.

The probabilistic first-order framework sketched above is termed statistical abduction
(Sato & Kameya, 2000) as it is an amalgamation of statistical inference and abduction where probabilistic facts play the role of abducibles , i.e. primitive hypotheses. 4 Statistical abduction is powerful in that it not only subsumes diverse symbolic-statistical frameworks such as HMMs (hidden Markov models, Rabiner, 1989), PCFGs (probabilistic context free grammars, Wetherell, 1980; Manning & Schütze, 1999) and (discrete) Bayesian networks
(Pearl, 1988; Castillo, Gutierrez, & Hadi, 1997) but gives us freedom of using arbitrarily complex logic programs for modeling. 5 The sem antic basis for statistical ab duction is distribution semantics introduced by Sato
(1995). It defines a parameterized distribution, actually a probability measure, over the set of possible truth assignments to ground atoms and enables us to derive a new EM algorithm 6 for ML estimation called the graphical EM algorithm (Kameya & Sato, 2000).

Parameter learning in statistical abduction is done in two phases, search and EM learning. Given a parameterized logic program and observations, the first phase searches for all explanations for the observations. Redundancy in the first phase is eliminated by tabulating partial explanations using OLDT search (Tamaki & Sato, 1986; Warren, 1992; Sagonas, T.,
& Warren, 1994; Ramakrishnan, Rao, Sagonas, Swift, & Warren, 1995; Shen, Yuan, You, &
Zhou, 2001). It returns a support graph which is a compact representation of the discovered explanations. In the second phase, we run the graphical EM algorithm on the support graph