The five conditions on the applicability of the graphical EM algorithm may look hard to satisfy at once. Fortunately, the modeling principle in Section 4.3 still stands, and with due care in modeling, it is likely to lead us to a program that meets all of them. Actually, we will see in the next section, programs for standard symbolic-statistical frameworks such as Bayesian networks, HMMs and PCFGs all satisfy the five conditions.

## 5. Complexity

In this section, we analyze the time complexity of the graphical EM algorithm applied to various symbolic-statistical frameworks including HMMs, PCFGs, pseudo PCSGs and Bayesian networks. The results show that the graphical EM algorithm is competitive with these specialized EM algorithms developed independently in each research field.

## 5.1 Basic Property

Since the EM algorithm is an iterative algorithm and since we are unable to predict when it converges, we measure time complexity by the time taken for one iteration. We therefore estimate time per iteration on the repeat loop of learn-gEM(DB,G) (G = G1,...,GT). We observe that in one iteration, each support graph for G t (1 < t < T ) is scanned twice, once by get-inside-probs( DB, G ) and once by get-expectations( DB, G ). In the scan, addition is performed on the t-explanations, and multiplication (possibly with division) is performed on the msw atoms and table atoms once for each. So time spent for G t per iteration by the graphical EM algorithm is linear in the size of the support graph , i.e. the number of nodes in the support graph for G t . Put

1< t < T , S E A p r
Recall that Tjpp is the set of table atom s for Gt, and hence Ajpg is the set of all t-explanations appearing in the right hand side of (20) in Subsection 4.7. So ξ num is the maximum number of t-explanations in a support graph for the Gt 's and Emaxsize the maximum size of a texplanation for the G t 's respectively. The following is obvious.

Proposition 5.1 The time complexity of the graphical EM algorithm per iteration is linear in the total size of support graphs, O(&num&maxsizeT) in notation, which coincides with the space complexity because the graphical EM algorithm runs on support graphs.

This is a rather general result, but when we compare the graphical EM algorithm with other EM algorithms, we must remember that the input to the graphical EM algorithm is support graphs (one for each observed atom) and our actual total learning time is OLDT time + (the number of iterations) ×O(fnumfmaxsizeT)