By the way, the Viterbi algorithm (Rabiner, 1989; Rabiner & Juang, 1993) provides for HMMs an efficient way of finding the most likely transition path for a given input/output string. A similar algorithm for parameterized logic programs that determines the most likely explanation for a given goal can be derived. It runs in time linear in the size of the support graph, thereby O(N 2 L) in the case of HMMs, the same complexity as the Viterbi algorithm (Sato & Kameya, 2000).

## 5.3 Pcfgs

We now compare the graphical EM algorithm with the Inside-Outside algorithm (Baker, 1979; Lari & Young, 1990). The Inside-Outside algorithm is a well-known EM algorithm for PCFGs (Wetherell, 1980; Manning & Schütze, 1999). 42  It takes a grammar in Chomsky normal form.  Given N nonterminals, a production rule in the grammar takes the form i → j,k (1 ≤ i,j,k ≤ N) (nonterminals are named by numbers from 1 to N and 1 is a starting symbol) or the form i → w where 1 < i < N and w is a terminal. In each iteration, it computes the inside probability and the outside probability of every partial parse tree of the given sentence to update parameters for these production rules. Time complexity is measured by time per iteration, and is described by N, the number of nonterminals, and L, the number of terminals in a sentence. It is O( N 3 L 3 T ) for T observed sentences (Lari
& Young, 1990).

To compare the graphical EM algorithm with the Inside-Outside algorithm, we start from a propositional program DB n = F n ∪ R n below representing the largest grammar containing all possible rules i → j, k in N nonterminals where nonterminal 1 is a starting symbol, i.e. sentence.

{msw(i,[d,d'],[j,k]) |1 ≤ i,j,k ≤ N,d,d' are numbers} I U {msw(i,d,w) | 1 ≤ i ≤ N,d is a number, w is a terminal} :-  msw(i,[do,d2],[j,k]), q(i,do,d2) 1 ≤ i, j, k ≤ N, R q(j,do,d1), 0 ≤ d 0 < d 1 < d 2 ≤ L q(k,d1,d2). U q(i,d,d+1)  :-  msw(i,d,w d+1). | 1 ≤ i≤ N,0 ≤ d ≤ L − 1 |
Figure 9: PCFG program DB p DB is an artificial parsing program whose sole purpose is to measure the size of an OLDT tree 43 created by the OLDT interpreter when it parses a sentence w1w2 · · · wL .  So