# Research Note Finding A Path Is Harder Than Finding A Tree

Christop her   Meek Microsoft Research, Redmond, WA 98052-6399 USA
MEEK @ MICROSOFT. COM

## Abstract

I consider the problem of learning an optimal path graphical model from data and show the problem to be NP-hard for the maximum likelihood and minimum description length approaches and a Bayesian approach. This hardness result holds despite the fact that the problem is a restriction of the polynomially solvable problem of finding the optimal tree graphical model.

## 1. Introduction

The problem of learning graphical models has received much attention within the Artificial Intelligence community.  Graphical models are used to represent and approximate joint distributions over sets of variables where the graphical structure of a graphical model represents the dependencies among the set of variables. The goal of learning a graphical model is to learn both the graphical structure and the parameters of the approximate joint distribution from data. In this note, I present a negative hardness result on learning optimal path graphical models.

Path graphical models are an interesting class of graphical models with respect to learning. This is due the fact that, in many situations, restricting attention to the class of path models is justified on the basis of physical constraints or temporal relationships among the variables. One example of this is the problem of identifying the relative positions of loci on a segment of DNA (e.g., Boehnke, Lange & Cox, 1991). In addition, one might be interested in obtaining a total order over a set of variables for other purposes such as visualization
(e.g., Ma & Hellerstein, 1999).

The main positive results on the hardness of learning graphical models are for learning tree graphical models. These have been presented for maximum likelihood (ML) criterion
(Edmonds, 1967; Chow & Liu, 1968) and adapted to a Bayesian criterion by Heckerman, Geiger, & Chickering (1995). Two NP-hardness results for learning graphical models have appeared in the literature. Those are the NP-hardness of finding the optimal Bayesian nnetwork structure with in-degree greater than or equal to two using a Bayesian optimality criterion (Chickering, 1996) and the problem of finding the ML optimal polytree (Dasgupta, 199).

In this note, I present a proof of the hardness of finding an optimal path graphical models for the maximum likelihood (ML) criterion, the minimum description length (MDL) criterion, and a Bayesian scoring criterion. Unlike the ML hardness result of Dasgupta, I
provide an explicit construction of a polynomial sized data set for the reduction and, unlike the Bayesian hardness result of Chickering (1996), I use a common "uninformative" prior.