
## 2. Optimal Graphical Models

One of the primary goals when learning a graphical model is to obtain an approximate joint distribution over a set of variables from data. In this note, I focus on directed graphical models for a set of discrete variables { X 1 , . . , X n } .  One component of a directed graphical model is its directed graphical structure that describes dependencies between the variables. A directed graphical model represents a family of distributions that factor according to the graphical structure G of the directed graphical model, more specifically,

$$P_{G}(X_{1},\ldots,X_{n})=\prod_{i\mathop{=}1}^{n}P(X_{i}|p a_{G}(X_{i}))$$

where pag (X i ) denotes the possibly empty set of parents of vertex X i in graph G . The subscript G is omitted when it is clear from context. The most common methods guiding the choice of a distribution from a family of distributions are maximum likelihood estimation and Bayesian estimation. Given a graphical structure and a set of cases for the variables
(also a prior distribution over the distributions in the case of the Bayesian approach), these methods provide an approximate joint distribution. For more details on graphical models and estimation see Heckerman (1998).

This leaves open the question of how one should choose the appropriate graphical struc­
ture. In the remainder of this section, I present the maximum likelihood (ML) criterion, the minimum discrimination length (MDL) criterion, and a Bayesian criterion for evaluating directed graphical models given a set of cases D . A value of the variable X i is denoted by x i and a value of the set of variables pa ( X i ) is denoted by pa ( x i ). The number of cases in D in which X i = x i and pa (X i ) = pa (x i ) is denoted by N (x i , pa (x i )) and the total number of cases in D is denoted by N .

One important property common to these scoring criteria is that the scores factor according to the graphical structure of the model. That is, the score for a graph G and data set D can be written as a sum of local scores for each of the variables

$$S c o r\,e(G,D)=\sum_{i}L o c a l S c o r\,e(X_{i}\,,p a\left(X_{i}\right)).$$

The local score for a variable X i is only a function of the counts for X i and pa (X i ) in the data set D and the number of possible assignments to the variables X i and pa ( X i ). Thus the structure of the graphical model determines which particular variables and counts are needed in the computation of the local score for a variable.

The log maximum likelihood scoring criterion for a graphical model is

$$\begin{array}{r c l}{{S c o r\,e_{M L}\big(G,D\big)}}&{{=}}&{{\sum_{i}L o c a l\,S c o r\,e_{M L}\big(X_{i}\,,\,p a\big(X_{i}\,\big)\big)}}\end{array}$$
$$\begin{array}{r c l}{{{\cal L}o c a l\,S c o r\,e_{M L}\left(X_{i}\,,p a\big(X_{i}\,\big)\right)}}&{{=}}&{{N\times H_{D}\big(X_{i}|p a\big(X_{i}\,\big)\big)}}\end{array}$$
$$(1)$$

where H D (X i | pα(X i )) is the empirical conditional entropy of X i given its parents, and is equal to

$$-\sum_{X_{i},p a\,(X_{i}\,)}\frac{N(x_{i},p a\,(x_{i}\,))}{N}\log\frac{N(x_{i},p a\,(x_{i}\,))}{N\,(p a\,(x_{i}\,))}.$$
