# Extensions Of Simple Conceptual Graphs: The Complexity Of Rules And Constraints

## Jean-François  Baget Marie-Laure  Mugnier

BAGET @ LIRMM. FR
MUGNIER@LIRMM.FR
LIRMM (CNRS & UM II), 161 rue Ada 34392 Montpellier, Cédex 5, France

## Abstract

Simple conceptual graphs are considered as the kernel of most knowledge representation formalisms built upon Sowa's model. Reasoning in this model can be expressed by a graph homomorphism called projection, whose semantics is usually given in terms of positive, conjunctive, existential FOL. We present here a family of extensions of this model, based on rules and constraints, keeping graph homomorphism as the basic operation. We focus on the formal definitions of the different models obtained, including their operational semantics and relationships with FOL, and we analyze the decidability and complexity of the associated problems (consistency and deduction). As soon as rules are involved in reasonings, these problems are not decidable, but we exhibit a condition under which they fall in the polynomial hierarchy.  These results extend and complete the ones already published by the authors. Moreover we systematically study the complexity of some particular cases obtained by restricting the form of constraints and/or rules.

## 1. Introduction

Conceptual graphs (CGs) have been proposed as a knowledge representation and reasoning model, mathematically founded both on logics and graph theory (Sowa, 1984). Though they have been mainly studied as a graphical interface for logics or as a diagrammatic system of logics (for instance, see Wermelinger, 1995, for general CGs equivalent to FOL), their graph-theoretic foundations have been less investigated. Most works in this area are limited to simple conceptual graphs, or simple graphs (Sowa, 1984; Chein & Mugnier, 1992), which correspond to the positive, conjunctive and existential fragment of FOL without functions.

This model has three fundamental characteristics:

1. objects are bipartite labelled graphs (nodes represent entities and relations between these entities);
2. reasonings are based on graph-theoretic operations, relying on a kind of graph homomorphism called projection; 3. it is logically founded, reasonings being sound and complete w.r.t. FOL semantics, usually by way of the translation called Φ
Main extensions of the simple graphs model, keeping graph homomorphism based operations and sound and complete semantics, are inference rules (Gosh & Wuwongse, 1995; Salvat & Mugnier, 1996; Salvat, 1998) and nested graphs (Chein, Mugnier, & Simonet, 1998; Preller, Mugnier, & Chein, 1998); for general CGs equivalent to FOL, an original deduction
©2002 AI Access Foundation and Morgan Kaufmann Publishers. All rights reserved.