
## 4.3  A Semi-Decidable Problem

Coulondre and Salvat (1998) proved that SR-DEDUCTION is semi-decidable with areduction from the the implication problem for TGDs. The reduction given by Baget (2001) (from the H ALTING P ROBLEM OF A T URING M ACHINE ) points out that SR - DED UCTION
is a computation model. We give here another reduction, from the WORD PROBLEM IN A
SEMI-THUE SYSTEM, that we will use as the starting point in the proof of Prop. 10.  This reduction is also interesting in itself since it proves that, even when rules are of the form "if path o x 1 . . . x k e then path o y 1 . . . y g e", SR-DEDUCTION remains semi-decidable.

## Theorem 5 (Coulondre & Salvat, 1998) Sr-Deduction Is Semi-Decidable.

Proof: First check that SR-DEDUCTION is not truly undecidable (i.e. there exists an algorithm that can decide in finite time if the answer to the problem is "yes"): when Q can be deduced from K, a breadth-first search of the tree of all derivations from K provides the answer in finite time.

We then prove that no algorithm is ensured to halt when the answer to the problem is
"no". Let us now show that SR-DEDUCTION is not decidable by building a reduction from the WORD PROBLEM IN A SEMI-THUE SYSTEM (Thue, 1914). This problem was proven semi-decidable by Post (1947, reduction to his correspondence Problem).

The WORD PROBLEM can be expressed as: let m and m ′ be two words, and Γ =
Sfrag replacements { 7 1 ; . . ; 7 k } be a set of rules, each rule 7 i being a pair of words ( α i , β i ) is there a derivation from m to m ′ ? There is an immediate derivation from m to m ′ (we note m → m ′ ) if, for some γ i , m = m 1 α j m 2 and m ′ = m 1 β j m 2 . A derivation from m to m ′ (we note m → m ′ )
is a sequence m = m 0 → m 1 → . . . → m p = m ′ .

![0_image_0.png](0_image_0.png)

Figure 10: Transformation from the WORD PROBLEM into SR-DEDUCTION
This problem can easily be expressed in the SR model. One concept type x ; is assigned to each letter x i .  There are three other concept types:  B (for "begin"), E (for "end") and T (for
"anything"). T is the greatest concept type and all other types are pairwise non-comparable.

There is one relation type s (for "has successor"). A word m = x 1 . . . x k is associated the graph G ( m ), and to any rule γ = ( y 1 . . y p ; z 1 . . . z g ) is associated the graph rule U ( γ ), as represented in Fig. 10. By a straightforward proof (a recurrence on the smallest derivation length), we obtain that to every path from the node typed B to the node typed E ("begin" to
"end") in a graph R -derived from G ( m ), corresponds a word (and not a subword) derivable from m t and reciprocally. It follows that m ~ m ' ~ G(m') ~ (G(m),U(F)).

□