system (Kerdiles, 1997) combines analytic tableaux with the simple graphs projection.  Some kind of constraints have been proposed to validate a knowledge base composed of simple graphs (Mineau & Missaoui, 1997; Dibie, Haemmerlé, & Loiseau, 1998).

We present here a family of extensions of the simple graphs model. The common ground for these extensions is that objects are colored simple graphs representing facts, rules or constraints, and operations are based upon projection. Given a knowledge base K and a simple graph Q (which may represent a query, a goal, . . . , depending on the application), the deduction problem asks whether Q can be deduced from K. According to the kinds of objects considered in K t different reasoning models are obtained, composing the SG family. Though similar notions of rules and constraints can be found in the CG literature, their combination in reasonings had never been studied.  One interest of our approach thus resides in providing a unifying framework combining rules and constraints in different ways.

In this paper, we focus on the formal definitions of these models, including their operational semantics and relationships with FOL, and we study the decidability and complexity of their associated decision problems, namely consistency and deduction. These results extend and complete the ones already published by the authors (Baget & Mugnier, 2001).

Though both consistency and deduction are undecidable in the most general model of this family, we had already used a decidable subset of rules to solve the SISYPHUS-I problem, a test-bed proposed in the knowledge acquisition community (Baget, Genest, & Mugnier, 199). We present here for the first time a detailed analysis of complexity when we restrict the knowledge base to this kind of rules (called range restricted rules). We also study particular cases of constraints.

In section 2 basic definitions and results about simple graphs are recalled.  Section 3 presents an overview of the SG family. In particular, we explain why we consider graphical features of the simple graphs model as essential for knowledge modeling and point out that these properties are preserved in the SG family.  In next sections we study the different members of the family.  Rules are introduced in section 4, constraints in section 5, and section 6 studies models combining rules and constraints. As soon as rules are involved in reasonings, the associated decision problems are not decidable, but we exhibit a condition
(finite expansion sets) under which computations always stop. In the particular case of range restricted rules, the complexity of these problems fall into the polynomial hierarchy.

Section 7 is devoted to these decidable cases. In section 8, relationships with other works are established. In particular we point out algorithmic connections with constraint satisfaction problems (CSP) and show that the problem of checking the consistency of a knowledge base composed of simple graphs and constraints ( SGC -consistency) is equivalent to that of deciding the consistency of a mixed CSP (MIXED-SAT, Fargier, Lang, & Schiex, 1996).

## 2. Basic Notions: The Sg Model

We recall in this section basic notions about simple conceptual graphs (Sowa, 1984; Chein &
Mugnier, 1992).  These graphs are considered as the kernel for most knowledge representation formalisms built upon Sowa's work. They are also the basic model for the SG family.