This theorem can be reformulated in terms of abductive inference (using in fact indirect abduction, see, for example, Konolige, 1996). Indeed, given a background theory Σ = Φ( S ), Φ( G ) and an observation O = ¬ Φ( C ), G violates C iff there is an abductive explanation for O of the form ¬ F , where F is a formula belonging to FOL( Λ , ∃ ).

## 5.3 Computational Complexity

The problem "does a given graph satisfy a given constraint?" is co-NP-complete if this constraint is negative (since we must check the absence of projection), but becomes Π f -
complete for a positive one ( I is co- NPNP ).

Theorem 8 (Complexity in SGC ) SGC-CONSISTENCY is Π 5 -complete (but is co-NP-complete if all constraints are negative).

Proof: Without change of complexity, one can consider that C is composed of only one positive constraint, say C . First recall that deciding whether a SG G satisfies C is done on the irredundant form of G. We shall consider two ways of integrating this fact in the complexity of SGC-CONSISTENCY. One way is to assume that the irredundant form of G is computed before the consistency check. This can be achieved with a number of calls to a projection oracle linear in the size of G (Mugnier, 1995). But, since we have then to solve a function problem (compute the irredundant form of G ) instead of a decision problem (is G irredundant?), we prefer to integrate irredundancy into the consistency check: then, for a projection π n from the trigger of C into G , the projection from C to G we look for does not necessarily extends π 0 , but extends the composition of a projection from G into one of its subgraphs (possibly equal to G itself) and π 0 .

First, SGC-CONSISTENCY belongs to Π 2 since it corresponds to the language L =
{x | Vy1 3y2 R(x, y1, y2)}, where x encodes an instance ( G, C ) of the problem and
(x, y 1 , y 2 ) E R iff y 1 encodes a projection π 0 from C (0) into G and y 2 encodes a projection π G from G into one of its subgraphs and a projection π from C into G s.t. π [ C i0 1 ] = π G ◦ π 0 .

Note that if G is in irredundant form, then π G is an automorphism.

Now, let us consider the problem B 2 : given a boolean formula E, and a partition
{X 1 , X 2 } of its variables, is it true that for any truth assignment for the variables in X 1 there exists a truth assignment for the variables in X 2 s.t. E is true? This problem is Π 2 -
complete, since its complementary B 2 is shown to be Σξ -complete by Stockmeyer (1977).

In order to build a polynomial reduction to SGC-CONSISTENCY , we use a restriction of this problem to k -CNFs, i.e. conjunctions of disjunctions with at most k literals per clause. Let us call 3- SAT f the special case where E is a 3- CNF, in other words an instance of 3- SAT.

Then 3- SAT 2 is also Π 2 -complete. Indeed, in the same paper (Th. 4.1), Stockmeyer shows that B 2 with E restricted to a 3-disjunctive normal form (3-DNF) remains E 2 -complete.

Since the negation of a 3-DNF is a 3-CNF, it follows that the complementary problem B 2 with E restricted to a 3-CNF is Π 2 -complete.

Let us now reduce 3-SAT5 to SGC-CONSISTENCY. The transformation used is very similar to the one from 3-SAT to SG-DEDUCTION (proof of theorem 2), illustrated in Fig. 4. Let E be an instance of 3-SAT. Let G(E) and Q(E) be the SGs obtained by the transformation described in the proof of Th. 2. The constraint C ( E ) = ( Q ( E ), ρ ( X 2 )) is obtained by adding a coloration to Q ( E ):  all relation nodes obtained from clauses (nodes typed C i ) and all nodes