# Fusions Of Description Logics And Abstract Description Systems

## Franz Baader

BAADER@CS. RWTH-AACHEN.DE
L UT Z® CS. RWT H-AA CH EN. D E
Carsten Lutz Teaching and Research Area for Theoretical Computer Science, RWTH Aachen, Ahornstraße 55, 52074 Aachen, Germany HOLGER.STURM@UNI-KONSTANZ.DE
Holger  Sturm Fachbereich Philosophie, Universitat Konstanz, 78457 Konstanz, Germany Frank Wolter Institut für Informatik, Universität Leipzig, Augustus-Platz 10-11, 04109 Leipzig, Germany WOLT ER@ INFORMAT IK. UNI-LEIP ZIG. DE

## Abstract

Fusions are a simple way of combining logics. For normal modal logics, fusions have been investigated in detail. In particular, it is known that, under certain conditions, decidability transfers from the component logics to their fusion. Though description logics are closely related to modal logics, they are not necessarily normal. In addition, ABox reasoning in description logics is not covered by the results from modal logics.

In this paper, we extend the decidability transfer results from normal modal logics to a large class of description logics. To cover different description logics in a uniform way, we introduce abstract description systems, which can be seen as a common generalization of description and modal logics, and show the transfer results in this general setting.

## 1. Introduction

Knowledge representation systems based on description logics (DL) can be used to represent the knowledge of an application domain in a structured and formally well-understood way (Brachman & Schmolze, 1985; Baader & Hollunder, 1991; Brachman, McGuinness, Patel-Schneider, Alperin Resnick, & Borgida, 1991; Woods & Schmolze, 1992; Borgida, 1995; Horrocks, 1998). In such systems, the important notions of the domain can be described by concept descriptions, i.e., expressions that are built from atomic concepts (unary predicates) and atomic roles (binary predicates) using the concept constructors provided by the description logic employed by the system.  The atomic concepts and the concept descriptions represent sets of individuals, whereas roles represent binary relations between individuals. For example, using the atomic concepts Woman and Human, and the atomic role child, the concept of all women having only daughters (i.e., women such that all their children are again women) can be represented by the description Woman Π ∀child.Woman, and the concept of all mothers by the description Woman ❒ ∃ child . Human. In this example, we have used the constructors concept conjunction ( Π ), value restriction ( ∀ R.C ), and existential restriction ( ∃ R.C ). In the DL literature, also various other constructors have been considered. A prominent example are so-called number restrictions, which are available in almost all DL systems. For example, using number restrictions the concept of all women ©2002 AI Access Foundation and Morgan Kaufmann Publishers. All rights reserved.