language.  General inclusion axioms in DLs are represented by term assertions and ABox assertions in DLs are represented by object assertions.

Definition 4 (Abstract description language). An abstract description language (ADL)
is determined by a countably infinite set V of set variables, a countably infinite set X of object variables, a (possibly infinite) countable set R of relation symbols of arity two, 3 and a (possibly infinite) countable set F of functions symbols f , which are equipped with arities n f. All these sets have to be pairwise disjoint.

The terms t, of this ADL are built using the follow syntax rules:
--
t j where x E V, f E F, and the Boolean operators ¬, Λ, V are different from all function symbols in F . For a term t, we denote by var(t) the set of set variables used in t. The symbol T is used as an abbreviation of x V ¬ x and ⊥ as an abbreviation for x ∧¬ x (where x is a set variable).

The term assertions of this ADL are - t 1 E t 2 , for all terms t 1 , t 2 ,
and the object assertions are
- R ( a, b ), for a, b ∈ X and R ∈ R ;
- (a : t), for a E X and t a term.

The sets of term and object assertions together form the set of assertions of the ADL.

From the DL point of view, the set variables correspond to concept names, object variables to individual names, relation symbols to roles, and the Boolean operators as well as the function symbols correspond to concept constructors.  Thus, terms correspond to concept descriptions. As an example, let us view concept descriptions of the DL ALCN", i.e., ALC extended with number restrictions and conjunction of roles, as terms of an ADL. Value restrictions and existential restrictions can be seen as unary function symbols: for each role description R, we have the function symbols f v R and f 3 R, which take a term t C
(corresponding to the concept description C ) and transform it into the more complex terms ff R ( tc ) and f 3 R ( tc ) (corresponding to the concept descriptions ∀ R.C and ∃ R.C ).  Similarly, nmber restrictions can be seen as nullary function symbols: for each role description R and each n E N, we have the function symbols f>nR and f<nR. Hence, the ALCN [1-concept description A Π ∀( R 1 Π R 2 ). ¬( B Π (≥ 2 R 1 )) corresponds to the term x A f v( R 1 Π R 2 )(¬( x B Λ
f( > 2 R 1 )). We will analyze the connection between ADLs and DLs more formally later on.

The semantics of abstract description systems is defined based on abstract description models. These models are the general semantic structures in which the terms of the ADL are interpreted. It should already be noted here, however, that an abstract description ssssem usually does not take into account all abstract description models available for the language: it allows only for a selected subclass of these models. This subclass determines the semantics of the system.