the difference between the usual union and the fusion of DLs, let us consider a simple example. Assume that the DL D 1 is ALC 1 i.e., it provides for the Boolean operators n, U,
¬ and the additional concept constructors value restriction VR.C and existential restriction 3R.C, and that the DL D2 provides for the Boolean operators and number restrictions
( < nR ) and ( > nR ). If an application requires concept constructors from both DLs for expressing its relevant concepts, then one would usually consider the union D 1 UD 2 of D 1 and D 2 , which allows for the unrestricted use of all constructors. For example, the concept description C 1 := ( ∃ R.A) Π( ∃ R. ¬ A) Π( ≤ 1 R) is a legal D 1 UD 2 description. Note that this description is unsatisfiable, due to the interaction between constructors of D 1 and D 2 . The fusion D 1 SD 2 of D 1 and D 2 prevents such interactions by imposing the following restriction:
one assumes that the set of all role names is partitioned into two sets, one that can be used in constructors of D 1 , and another one that can be used in constructors of D 2 . Thus, the description C 1 from above is not a legal D 1 ® D 2 description since it uses the same role R both in the existential restrictions (which are D 1 -constructors) and in the number restriction (which is a D 2 -constructor). In contrast, the descriptions ( ∃ R 1 . A) ∩ ( ∃ R 1 . ¬ A) ∩ ( ≤ 1 R 2 )
and ( ∃ R 1 . ( ≤ 1 R 2 )) are admissible in D 1 ⊗ D 2 since they employ different roles in the D 1 -
and D 2 -constructors. If the concepts that must be expressed are such that they require both constructors from D 1 and D 2 , but the ones from D 1 for other roles than the ones from D 2 , then one does not really need the union of D 1 and D 2 ; the fusion would be sufficient.

What is the advantage of taking the fusion instead of the union? Basically, for the union of two DLs one must design new reasoning methods, whereas reasoning in the fusion can be reduced to reasoning in the component DLs. Indeed, reasoning in the union may even be undecidable whereas reasoning in the fusion is still decidable. As an example, we consider the DLs (i) ALCF, which extends the basic DL ALC by functional roles (features) and the same-as constructor (agreement) on chains of functional roles (Hollunder & Nutt, 1990; Baader, Bürckert, Nebel, Nutt, & Smolka, 1993); and (ii) ALC+,°, 1 , which extends ALC by transitive closure, composition, and union of roles (Baader, 1991; Schild, 1991).  For  both DLs, subsumption of concept descriptions is known to be decidable (Hollunder & Nutt, 1990; Schild, 1991; Baader, 1991). However, their union ALC F+,, 1 has an undecidable subsumption problem (Baader et al., 1993). This undecidability result depends on the fact that, in ALCF+,°,µ, the role constructors transitive closure, composition, and union can be applied to functional roles that also appear within the same-as constructor. This is not allowed in the fusion ALCF ® ALC + 1 ° 1 1 .  Of course, failure of a certain undecidability proof does not make the fusion decidable.

Why do we know that the fusion of decidable DLs is again decidable? Actually, in general we don't, and this was our main reason for writing this paper. The notion "fusion" was introduced and investigated in modal logic, basically to transfer results like finite axiomatizability, decidability, finite model property, etc. from uni-modal logics (with one pair of box and diamond operators) to multi-modal logics (with several such pairs, possibly satisfying different axioms). This has led to rather general transfer results (see, e.g.,
Wolter, 1998; Kracht & Wolter, 1991; Fine & Schurz, 1996; Spaan, 1993; Gabbay, 1999 for results that concern decidability), which are sometimes restricted to so-called normal modal logics (Chellas, 1980). Since there is a close relationship between modal logics and DLs (Schild, 1991), it is clear that these transfer results also apply to some DLs. The question is, however, to which DLs exactly and to which inference problems. First, some DLs