We start with introducing restrictions on role interpretations, since we need to refer to such restrictions when defining certain concept constructors.

## 2.1.1 Restrictions On Role Interpretations

These restrictions enforce the interpretations of roles to satisfy certain properties, such as functionality, transitivity, etc. We consider three prominent examples:
1. Functional roles. Here one considers a subset N F of the set of role names N R ,
whose elements are called features. An interpretation must map features f ∈ N F to functional binary relations f x ⊂ ∆ x ∆ x , i.e., relations satisfying ∀ a, b,c.f x ( a, b ) ∧
f I (a,c) -> b = c. We will sometimes treat functional relations as partial functions, and write f I ( a ) = b rather than f I ( a, b ). ALC extended with features is denoted by ACC
2. Transitive roles. Here one considers a subset N R + of N R . Role names R E N R +
are called transitive roles. An interpretation must map transitive roles R E N R + to transitive binary relations R ⋆ ⊂ ∆ ⋆ × ∆ ⋆ . ALC extended with transitive roles is denoted by ALC R+
3. Role hierarchies. A role inclusion axiom is an expression of the form R E S with R, S E N R .  A finite set H of role inclusion axioms is called a role hierarchy.  An interpretation must satisfy R ⋆ ⊂ S ⋆ for all R ⊆ S ∈ H . ALC extended with a role herarchy H is denoted by ALCH(H). If H is clear from the context or irrelevant, we write ALCH instead of ALCH(H)
The above restrictions can also be combined with each other.  For example, ALCHR+ is ALC
with a role hierarchy and transitive roles.

Transitive roles in DLs were first investigated by Sattler (1996). Features were introduced in DLs by Hollunder and Nutt (1990) and (under the name "attributes") in the CLASSIC system (Brachman et al., 1991), in both cases in conjunction with feature agreements and disagreements (see concept constructors below). Features without agreements and disagreements are, e.g., used in the DL SHIF (Horrocks & Sattler, 1999), albeit in a more expressive "local" way, where functionality can be asserted to hold at certain individuls, but not necessarily on the whole model. According to our naming scheme, we indicate the presence of features in a DL by the letter f in subscript. 1 A remark on role hieraries is also in order: in our definition, if H 1 and H 2 are different role hierarchies, then ALCH(H,) and ALCH(H,) are different DLs. In the DL literature, usually only one logic ALC H is defined and role hierarchies are treated like TBoxes, i.e.,
stisfiability and subsumption are defined relative to TBoxes and role hierarchies (see, e.g., Horrocks, 1998). For our purposes, however, it is more convenient to define one DL per role herarchy since distinct role hierarchies impose distinct restrictions on the interpretation of roles.  The advantages of this approach will become clear later on when frames and abstract description systems are introduced.

7