
| Name                           | Syntax   | Semantics                                          | Symbol                 |    |
|--------------------------------|----------|----------------------------------------------------|------------------------|----|
| { α ∈ Δ T | | R T ( α )| ≥ n } |          |                                                    |                        |    |
| Unqualified                    | ≥nR      | N                                                  |                        |    |
| nmmmmer restrictions           | ≤nR      | {a E Az I                                          | |R 2 (a)| 2 n)         |    |
| Qualified                      | ≥ nR C   | {a E Az                                            | |R 2 (α) ∩ C 2 | ≥ n } | g  |
| nmmmmer restrictions           | <nR.C    | { α ∈ Δ T | | R T ( α ) ∩ C T | ≤ n }              |                        |    |
| Nominals                       | I C A X  | with | I T | = 1                                   | o                      |    |
| I                              |          |                                                    |                        |    |
| Feature agreement              | uu       | { a ∈ Δ T | ∃ b ∈ Δ T . u T ( a ) = b = u Z ( a )} | J                      |    |
| and disagreement               | uu       | {a E  A T  |                                       |                        |    |
| u I (a) = b1 = b2 = u I (b1)}  |          |                                                    |                        |    |

## 2.1.2  Concept Constructors

Concept constructors take concept and /or role descriptions and transform them into more complex concept descriptions. In addition to the constructors available in ALC, various other concept constructors are considered in the DL literature. A small collection of such constructors can be found in Figure 1, where [ S ] denotes the cardinality of a set S . The symbols in the rightmost column indicate the naming scheme for the resulting DL. As mentioned above the name modifiers for concept constructors are not written in subscript, they are appended to the language name. For example, ALC HR + extended with qualified number restrictions is called ALCQHR+. The syntax of the extended DLs is as expected, i.e., the constructors may be arbitrarily combined. The semantics is obtained by augmenting the semantics of ALC with the appropriate conditions, which can be found in the third column in Figure 1. Nominals and feature (dis)agreements need some more explanation:
- Nominals. We consider a set No of (names for) nominals, which is pairwise disjoint to the sets N C , N R , and N I . Elements from N O are often denoted by I (possibly with index). An interpretation must map nominals to singleton subsets of ∆ T . The intention underlying nominals is that they stand for elements of ∆ , just like individual names. However, since we want to use the nominal I E NO as a (nullary) concept constructor, I must interpret them by a set, namely the singleton set consisting of the individual that I denotes.

- Feature (dis)agreements. ALCF is the extension of ALC f with feature agreements and disagreements.  Beside the additional concept constructors, ALCF uses feature chains as part of the (dis)agreement constructor. A feature chain is an expression of the form u = f 1 0 ··· f n . The interpretation u T of such a feature chain is just the composition of the partial functions f f , . . , f , where composition is to be read from left to right.

DLs including nominals or feature (dis)agreements and additional concept constructors or restrictions on role interpretations are defined (and named) in the obvious way.

Number restriction are available in almost all DL systems. The DL ALCN (i.e., ALC
extended with number restrictions) was first treated by Hollunder and Nutt (1990), as was ALCF. The DL ALCQ was first investigated by Hollunder and Baader (1991), and ALCO
by Schaerf (1994).