# Improving The Efficiency Of Inductive Logic Programming Through The Use Of Query Packs

Hendrik  Blockeel HENDRIK. BLO CKEEL @CS. KULEUV EN. AC. BE
Katholieke Universiteit Leuven, Department of Computer Science Celestimentaan 200A, B-3001 Leuven, Belgium Luc Dehaspe PharmaDM, Ambachtenlaan 54D, B-3001 Leuven, Belgium LUC. DEHA SPE@PHARMADM. COM
Bart Demoen BART.DEMOEN@CS.KULEUVEN.AC.BE
Gerda Janssens GERDA JANSSENS@CS KULEUVEN.AC.BE
Jan Ramon JA N. RA MO N @ CS. K UL EUV EN A C. B E
Katholieke Universiteit Leuven, Department of Computer Science Celestimentaan 200A, B-3001 Leuven, Belgium Henk  Vandecasteele HENK VANDECA STEELE@PHARMADM.COM
PharmaDM, Ambachtenlaan 54D, B-3001 Leuven, Belgium

## Abstract

Inductive logic programming, or relational learning, is a powerful paradigm for machine learning or data mining.  However, in order for ILP to become practically useful, the efficiency of ILP systems must improve substantially.  To this end, the notion of a query pack is introduced: it structures sets of similar queries. Furthermore, a mechanism is described for executing such query packs. A complexity analysis shows that considerable efficiency improvements can be achieved through the use of this query pack execution mechanism.

This claim is supported by empirical results obtained by incorporating support for query pack execution in two existing learning systems.

## 1. Introduction

Many data mining algorithms employ to some extent a generate-and-test approach: large amounts of partial or complete hypotheses are generated and evaluated during the data mining process. This evaluation usually involves testing the hypothesis on a large data set, a process which is typically linear in the size of the data set. Examples of such data mining algorithms are Apriori (Agrawal et al., 1996), decision tree algorithms (Quinlan, 1993a; Breiman et al., 1984), algorithms inducing decision rules (Clark & Niblett, 1989), etc.

Even though the search through the hypothesis space is seldom exhaustive in practical situations, and clever branch-and-bound or greedy search strategies are employed, the number of hypotheses generated and evaluated by these approaches may still be huge. This is especially true when a complex hypothesis space is used, as is often the case in inductive logic programming (ILP), where the sheer size of the hypothesis space is an important contribution to the high computational complexity of most ILP approaches. This computational complexity can be reduced, however, by exploiting the fact that there are many similarities between hypotheses.

©2002 AI Access Foundation and Morgan Kaufmann Publishers. All rights reserved.