stems. The "examples in outer loop" strategy has important advantages when processing large data sets, mainly due to the ability to process them efficiently without having all data in main memory at the same time (Mehta et al., 1996; Blockeel et al., 1999).

## 3.3 Computational Complexity

We estimate the speedup factor that can be achieved using query pack execution in two steps: first we consider one-level packs, then we extend the results towards deeper packs.

Lower and upper bounds on the speedup factor that can be achieved by executing a one-level pack instead of separate queries can be obtained as follows. For a pack containing n queries qi = (a, bi), let Ti be the time needed to compute the first answer substitution of qi if there are any, or to obtain failure otherwise. Let ti be the part of Ti spent within a and t ′ the part of T i spent in b i . Then T s = ∑ i ( t i + t ′ i ) and T p = max( t i ) + ∑ i t ′ i with T s representing the total time needed for executing all queries separately and T p the total time neded for executing the pack. Introducing c = Ei ti / Ei ti , which roughly represents the ratio of the computational complexity in the shared part over that in the non-shared part, we have

$$\frac{T_{s}}{T_{p}}=\frac{\sum_{i}t_{i}+\sum_{i}t_{i}^{\prime}}{\max_{i}t_{i}+\sum_{i}t_{i}^{\prime}}=\frac{c+1}{\frac{\max_{i}t_{i}}{\sum_{i}t_{i}^{\prime}}+1}\tag{1}$$

Now defining K as the ratio of the maximal tj over the average tj, i.e.

we can rewrite Equation (1) as $\frac{1}{2}$
Since $\frac{\sum_i t_i}{n}\leq\max t_i\leq\sum_i t_i$ we. 
$$K={\frac{\operatorname*{max}_{i}t_{i}}{\sum_{i}t_{i}/n}}$$
$${\frac{T_{s}}{T_{p}}}={\frac{c\,+\,1}{{\frac{K}{n}}c\,+\,1}}$$
$$\left(\,2\right)$$

≤ max t i ≤ ∑ i t i we know 1 ≤ K ≤ n , whi leads to the following bounds:

$$1\leq{\frac{T_{s}}{T_{p}}}\leq{\frac{c+1}{{\frac{c}{n}}+1}}<\operatorname*{min}(c+1,n)$$
$$\left({\mathfrak{J}}\right)$$

Thus the speedup factor is bounded from above by the branching factor n and by the ratio c of computational complexity in the shared part over the computational complexity of the non-shared part; and a maximal speedup can be attained when maxt; ~ E t; /n (or, K ~ 1), in other words when the ti for all queries are approximately equal.

For multi-level packs, we can estimate the efficiency gain as follows. Given a query q i ,
let Ti be defined as above (the total time for finding 1 answer to gi or obtaining failure). Instead of t i and t i , we now define t i , as the time spent on level l of the pack when solving q i ; counting the root as level 0 and denoting the depth of the pack with d we have Tj = Ej=o tj,.

Further define T i i as the time spent on level i or deeper: T i i = E i = i t i ,j with d the depth of the pack. (Thus T i = T i o .). We will assume a constant branching factor b in the pack.

Finally, we define t t = E i t i i / n with n = U d . For simplicity, in the formulae we implicitly assume that i always ranges from 1 to n with n the number of queries, unless explicitly