adding all of the refinements to A*'s queue; part of the efficiency of A* is then lost, but the pack execution mechanism is exploited to a larger extent. Which of these two effects is dominant will depend on the application: if most of the first-level refinements would be further refined anyway at some point during the search, clearly there will be a gain in executing a two-level pack; otherwise there may be a loss of efficiency.  For instance, if executing a two-level pack takes x times as much time as a one-level pack, it will bring an efficiency gain only if at least x of the first level refinements would afterwards be refined themselves.

## 4.2  Level-Wise Frequent  Pattern Discovery

An alternative family of data mining algorithms scans the refinement lattice in a breadthfirst manner for queries whose frequency exceeds some user-defined threshold. The bestknown instance of these level-wise algorithms is the APRIORI method for finding frequent item-sets (Agrawal et al., 1996). Warmr (Dehaspe & Toivonen, 1999) is an ILP variant of attribute-value based APRIORI.

Query packs in WARMR correspond to hash-trees of item-sets in APRIORI: both are used to store a subgraph of the total refinement lattice down to level n. The paths from the root down to level n —1 in that subgraph correspond to frequent patterns. The paths from root to the leaves at depth n correspond to candidates whose frequency has to be computed. Like hash-trees in APRIORI, query packs in WARMR exploit massive similarity between candidates to make their evaluation more efficient. Essentially the WARMR algorithm starts with an empty query pack and iterates between pack evaluation and pack extension (see Figure 8). The latter is achieved by adding all potentially frequent refinements 3 of all leaves in the pack, i.e., adding another level of the total refinement lattice.

## 5. Experiments

The goal of this experimental evaluation is to empirically investigate the actual speedups that can be obtained by re-implementing ILP systems so that they use the pack execution meanism. At this moment such re-implementations exist for the Tilde and Warmr systems, hence we have used these for our experiments.  These re-implementations are available within the ACE data mining tool, available for academic use upon request. 4 We attempt to quantify (a) the speedup of packs w.r.t. to separate execution of queries (thus validating our complexity analysis), and (b) the total speedup that this can yield for an ILP system.

The data sets that we have used for our experiments are the following:
- The Mutagenesis data set : an ILP benchmark data set, introduced to the ILP community by Srinivasan et al. (1995), that consists of structural descriptions of 230 molecules that are to be classified as mutagenic or not. Next to the standard Mutagenesis data set, we also consider versions of it where each example occurs n times;