
| Level   | No packs   | With packs ILPROLOG   | speedup ratio   |       |        |      |
|---------|------------|-----------------------|-----------------|-------|--------|------|
| total   | exec       | total                 | exec            | net   | exec   |      |
| l       | 0.24       | 0.22                  | 0.24            | 0.23  | 1.00   | 0.96 |
| 2       | 0.83       | 0.75                  | 0.77            | 0.68  | 1.08   | 1.10 |
|         | 3.28       | 2.82                  | 2.34            | 1.92  | 1.40   | 1.47 |
| 4       | 1.56       | 9.31                  | 6.08            | 4.28  | 1.90   | 2.18 |
| 5       | 38.34      | 28.11                 | 16.20           | 8.15  | 2, 3 7 | 3.45 |
| 6       | 75.51      | 46.97                 | 36.57           | 12.22 | 2.06   | 3.84 |
| 7       | 135.64     | 71.60                 | 68.96           | 15.59 | 1.97   | 4.59 |
| 8       | 186.23     | 84.93                 | 102.46          | 17.82 | 1.82   | 4.77 |
| g       | 210.82     | 88.97                 | 120.76          | 18.52 | 1.75   | 4.80 |
| 10      | 216.61     | 89                    | 125.84          | 18.88 | 1.72   | 4.73 |

the packs, in contrast to TILDE where larger packs yielded higher speedups. At first sight we found this surprising; however it becomes less so when the following observation is made.

When refining a pack into a new pack by adding a level, WARMR prunes away branches that lead only to infrequent queries. There are thus two effects when adding a level to a pack:
one is the widening of the pack at the lowest level (at least on the first few levels, a new pack typically has more leaves than the previous one), the second is the narrowing of the pack as a whole (because of pruning). Since the speedup obtained by using packs largely depends on the branching factor of the pack, speedup factors can be expected to decrease when the narrowing effect is stronger than the widening-at-the-bottom effect. This can be seen, e.g, in the small-mutagenesis experiment, where at the deepest levels queries are becoming less frequent. For the mutagenesis experiment with the medium size language, query execution speedup factors are larger as the number of queries increases much faster. For the mutagenesis experiment with the large language, it is the total speedup that is large, as the language generates so many queries that the most time-consuming part becomes the administration and storage in memory. The packs version is much faster as it stores the queries in trees, requiring significantly less memory.

## 5.3 Comparison With Other Engines

Implementing a new special-purpose Prolog engine, different from the already existing ones, carries a risk: given the level of sophistication of popular Prolog engines, it is useful to check whether the new engine performs comparably with these existing engines, at least for the tasks under consideration here. The efficiency gain obtained through query pack execution should not be offset by a less efficient implementation of the engine itself.

Originally the Tilde and Warmr systems were implemented in MasterProLog.

In an attempt to allow them to run on other platforms, parts of these systems were reimplemented into a kind of "generic" Prolog from which implementations for specific Prolog engines (SICS TUS, ILP ROLOG ) can easily be derived (the low level of standardisation of Prolog made this necessary). Given this situation, there are two questions to be answered: