Given a set of queries S and a set of examples E the main task is to determine which queries Q E S cover which examples e E . We formalise this using the notion of a result set:
Definition 1 (Result set) The result set of a set of queries S in a deductive database D
for key K and example set E, is RS(S,K,D,E) = {(K0,i)|Q, E S and K0 E E and Q,0 succeeds in D}
Similar to the learning from interpretations setting defined in (De Raedt, 1997), the problem setting can now be stated as:
Given: a set of conjunctive queries S, a deductive database D, a tuple K of variables that occur in each query in S, and an example set E
Find: the result set RS ( S, K, D, E ); i.e., find for each query Q in S those ground instantiations θ of K for which Kθ ∈ E and Qθ succeeds in D .

Example 1 Assume an ILP system learning a definition for grandf ather/2 wants to evalute the following hypotheses:
grandfather(X,Y) :- parent(X,Z), parent(Z,Y), male(X). grandfather(X,Y) :- parent(X,Z), parent(Z,Y), female(X).

Examples are of the form grandfather(gf,gc) where gf and gc are constants; hence each example is uniquely identified by a ground substitution of the tuple ( X, Y ). So in the above problem setting the set of Prolog queries S equals {(?- parent(X,Z), parent(Z,Y),
male(X)), (?- parent(X,Z), parent(Z,Y), female(X))} and the key K  equals (X,Y).

Given a query Qi E S, finding all tuples (x,y) for which ((x,y),i) E R (with R the result set as defined above) is equivalent to finding which of the grandfather(x,y) facts in the example set are predicted by the clause grandfather(X,Y) :- Qi.

The generality of our problem setting follows from the fact that once it is known which queries succeed for which examples, the statistics and heuristics that typical ILP systems use can be readily obtained from this. A few examples:

- discovery of frequent patterns (Dehaspe & Toivonen, 1999): for each query Qi the number of key instantiations for which it succeeds just needs to be counted, i.e.,
freq(Qi) = |{K0|(K0,i) E R}| with R the result set.

- induction of Horn clauses (Muggleton, 1995; Quinlan, 1993b):  the accuracy of a clause H :- Q i (defined as the number of examples for which body and head hold, divided by the number of examples for which the body holds) can be computed as | K0 || K0 i | ERAD || with R the result set.

- induction of first order classification or regression trees (Kramer, 1996; Blockeel &
De Raedt, 1998; Blockeel et al., 1998): the class entropy or variance of the examples covered (or not covered) by a query can be computed from the probability distribution of the target variable; computing this distribution involves simple counts similar to the ones above.