
After transforming the grand father/2 clauses into grandfather((X,Y)),I) :- parent(X,Z), parent(Z,Y), male(X), I = 1. grandfather((X,Y)),I) :- parent(X,Z), parent(Z,Y), female(X), I = 2.

the result set can clearly be computed by collecting for all grounding θ's where Kθ ∈ E the answers to the query ?- grandfather(K0,I) . In Section 3 the queries will have a literal I = i at the end or another goal which by side-effects results in collecting the result set.

In practice, it is natural to compute the result set using a double loop: one over examples and one over queries and one has the choice as to which is the outer loop.  Both the "examples in outer loop" and the "queries in outer loop" have been used in data mining systems; in the context of decision trees, see for instance Quinlan (1993a) and Mehta et al. (1996). We shall see further that the redundancy removal approach we propose uses the "examples in outer loop" strategy. In both approaches however, given a query and a key instantiation, we are interested only in whether the query succeeds for that key instantiation. This implies that after a particular query has succeeded on an example, its execution can be stopped.

In other words: computing the result set defined above boils down to evaluating each query on each example, where we are only interested in the existence of success for each such evaluation. Computing more than one solution for one query on one example is unnecessary.

## 3. Query Packs

For simplicity, we make abstraction of the existence of keys in the following examples.  What is relevant here, is that for each query we are only interested in whether it succeeds or not, not in finding all answer substitutions.

Given the following set of queries p(X), I = 1.

p(X), q(X,a), I = 2. p(X), q(X,b), I = 3. p(X), q(X,Y), t(X), I = 4.

p(X), q(X,Y), t(X), r(Y,1), I = 5.

we can choose to evaluate them separately. Since we are only interested in one - the first –
success for each query, we would evaluate in Prolog the queries oce((p(X), I = 1)).

once((p(X), q(X,a), I = 2)).

once((p(X), q(X,b), I = 3)).

once((p(X), q(X,Y), t(X), I = 4)).

oce((p(X), q(X,Y), t(X), r(Y,1), I = 5)).

The wrapper once /1 is a pruning primitive and prevents the unnecessary search for more solutions. Its definition in Prolog is simply once(Goal) :- call(Goal), !.