An alternative way to evaluate the queries consists in merging them into one (nested)
disjunction as in:
p(X), (I=1 ; q(X,a), I=2 ; q(X,b), I=3 ; q(X,Y), t(X), (I=4 ; r(Y,1), I=5)).

The set of queries can now be evaluated as a whole: the success of one bran in the disjunctive query corresponds to the success of the corresponding individual query.

Compared to the evaluation of the individual queries, the disjunctive query has both an advantage and a disadvantage:

+ all the queries have the same prefix p(X), which is evaluated once in each individual query, while in the disjunctive query, the goal p(X) is evaluated only once; depending on the evaluation cost of p/1, this can lead to arbitrary performance gains.
l

the usual Prolog pruning primitives are not powerful enough to prevent all the unnecessary backtracking after a bran in the disjunctive query has succeeded; this is explained further in Example 2.
Example 2 In this example the literals I = i have been left out, because they do not contribute to the discussion:
p(X), q(X).

p(X), r(X).

Evaluating these queries separately means evaluating oce((p(X), q(X))),
oce((p(X), r(X))),
or equivalently p(X), q(X), !.

p(X), r(X), !.

The corresponding disjunctive query is p(X), (q(X) ; r(X)).

We can now try to place a pruning primitive in the disjunctive query: !/O at the end of each branch results in p(X), (q(X), ! ; r(X), !)
The scope of the first cut is clearly too large: after the goal q(X) has succeeded, the cut will prevent entering the second branch.  It means that adding the cut in the disjunctive query leads to a wrong result.

Using once/1 in the disjunctive query results in p(X), (once(q(X)) ; once(r(X)))