This results in a correct query. However, both branches are still executed for every binding that the goal p(X) produces, even if both branches have succeeded already.

The combination of the advantage of the disjunctive query with the advantage of the individual query with pruning (once or cut) results in the notion of the query pack. Syntactically, a query pack looks like a disjunctive query where the ; control construct is replaced by a new control construct denoted by or . So the query pack corresponding to the disjunctive query above is p(X), (I=1 or q(X,a), I=2 or q(X,b), I=3 or q(X,Y), t(X), (I=4 or r(Y,1), I=5))
This query pack can be represented as the tree in Figure 1. For a query pack Q such a tree has literals or conjunctions of literals in the nodes. Each path from the root to a leaf node represents a conjunctive query Q which is a member of Q , denoted Q E Q . The or construct is implicit in the branching points.

![0_image_0.png](0_image_0.png)

Figure 1: A query pack.

The intended procedural behaviour of the or construct is that once a branch has suc­
ceeded, it is effectively pruned away from the pack during the evaluation of the query pack on the current example.  This pruning must be recursive, i.e., when all branches in a subtree of the query pack have succeeded, the whole subtree must be pruned. Evaluation of the query pack then terminates when all subtrees have been pruned or all of the remaining queries fail for the example.

The semantics of the or construct and its efficient implementation is the subject of the rest of this section. It should however be clear already now that in the case that all the answers of each query are needed, pruning cannot be performed and the disjunctive query is already sufficient, i.e., query packs are useful when a single success per query suffices.

## 3.1  Efficient Execution Of Query Packs

In Section 3.1.2, a meta-interpreter is given that defines the behaviour of query packs. In practice this meta-interpreter is not useful, because in many cases the meta-interpreter itself causes more overhead than the use of query packs can compensate for. Indeed, previously reported results (Demoen et al., 1999; Blockeel, 1998) indicate that the overhead involved in a high-level Prolog implementation destroys the efficiency gain obtained by redundancy reduction. Moreover as discussed in Section 3.1.2, the meta-interpreter does not have the desired time-complexity. This shows that the desired procedural semantics of or can be