# When Do Numbers Really Matter?

Hei Chan hei@cs.ucla.edu Adnan Darwiche darwiche@cs.ucla.edu Computer Science Department University of California, Los Angeles Los Angeles, CA 90095, USA

## Abstract

Common wisdom has it that small distinctions in the probabilities (parameters) quantifying a belief network do not matter much for the results of probabilistic queries. Yet, one can develop realistic scenarios under which small variations in network parameters can lead to significant changes in computed queries. A pending theoretical question is then to analytically characterize parameter changes that do or do not matter. In this paper, we study the sensitivity of probabilistic queries to changes in network parameters and prove some tight bounds on the impact that such parameters can have on queries. Our analytic results pinpoint some interesting situations under which parameter changes do or do not matter. These results are important for knowledge engineers as they help them identify influential network parameters. They also help explain some of the previous experimental results and observations with regards to network robustness against parameter changes.

## 1. Introduction

A belief network is a compact representation of a probability distribution (Pearl, 1988; Jensen, 2001). It consists of two parts, one qualitative and **the other quantitative. The**
qualitative part of a belief network (called its structure) **is a directed acyclic graph in**
which nodes represent domain variables and edges represent **direct influences between these**
variables. The quantitative part of a belief network is a set **of conditional probability tables** (CPTs) that quantify our beliefs in such influences. Figure 1 depicts the structure of a belief network and Figure 2 depicts its CPTs.1 Automated reasoning systems based on belief networks have become quite popular recently as they have enjoyed much success in a number of real-world applications. Central to the development of such systems is the construction of a belief network (hence, a probability distribution) that faithfully represents the domain of **interest. Although the automatic**
synthesis of belief networks—based on design information in certain applications and based on learning techniques in others—has been drawing a lot of attention recently, mainstream methods for constructing such networks continue to be based **on traditional knowledge engineering (KE) sessions involving domain experts. One of the central issues that arise in**
such KE sessions is the assessment of impact that changes in network parameters may have on probabilistic queries of interest.

Consider for example the following common method for constructing belief networks in medical diagnosis applications (Coup´e, Peek, Ottenkamp, **& Habbema, 1999). First, the**