
## Ratio: Pr (Y | E)/Pr (Z | E) ≥ Ǫ.

These two constraints often arise when we debug belief networks. For example, we can make event y more likely than event z, given evidence e**, by specifying the constraint,**
Pr (y | e) − Pr (z | e) ≥ 0, or we can make event y at least twice as likely as event z**, given** evidence e, by specifying the constraint, Pr (y | e)/Pr (z | e) ≥ **2. We will discuss next how**
one would enforce the two constraints, but we need to settle some notational conventions and technical preliminaries first.

Variables are denoted by upper-case letters (A**) and their values by lower-case letters (**a).

Sets of variables are denoted by bold-face upper-case letters (A**) and their instantiations**
are denoted by bold-face lower-case letters (a). For a variable A with values true and **false**,
we use a to denote A = true and a to denote A = false. The CPT for variable X **with**
parents U defines a set of conditional probabilities of the form Pr (x | u), where x **is a value**
of variable X, u is an instantiation of parents U, and Pr (x | u**) is a probability known as a**
network parameter and denoted by θx|u**. We finally recall a basic fact about belief networks.**
The probability of some instantiation x of all network variables X **equals the product**
of all network parameters that are consistent with that instantiation. For example, the probability of instantiation fire, tampering, smoke, alarm, leaving, report **in Figure 1 equals**
.01 × .98 × .9 × .99 × .12 × .**01, which is the product of network parameters (from Figure 2)** that are consistent with this instantiation.

## 2.1 Binary Variables

We first consider the parameters of a binary variable X, with two values x and x **and,**
hence, two parameters θx|u and θx|u for each parent instantiation u**. We assume that for**
each variable X and parent instantiation u we have a meta parameter τx|u**, such that**
θx|u = τx|u and θx|u = 1 − τx|u**. Therefore, our goal is then to determine the amount of** change to the meta parameter τx|u **which would lead to a simultaneous change in both** θx|u and θx|u. We use the meta parameter τx|u **because it is not meaningful to change only** θx|u or θx|u without changing the other since θx|u + θx|u **= 1.**
First we observe that the probability of an instantiation e, Pr (e**), is a linear function**
in any network parameter θx|u **in a belief network (Russell, Binder, Koller, & Kanazawa,** 1995; Castillo et al., 1997). In fact, the probability is linear in any meta parameter τx|u.

Theorem 2.1 The derivative of Pr (e) with respect to the meta parameter τx|u **is given by:**

$${\frac{\partial P r(\mathbf{e})}{\partial\tau_{x|\mathbf{u}}}}={\frac{P r(\mathbf{e},x,\mathbf{u})}{\theta_{x|\mathbf{u}}}}-{\frac{P r(\mathbf{e},{\overline{{x}}},\mathbf{u})}{\theta_{{\overline{{x}}}|\mathbf{u}}}},$$
$\text{o}\;\;3\;\;\;\text{iii}$
, (1)
when θx|u 6= 0 and θx|u 6= 0.

3 **We will designate the derivative as constant** αe.

In Theorem 2.1, αe = Pr (e, x, u)/θx|u − Pr (e, x, u)/θx|u **is a constant in terms of both**
θx|u and θx|u (and consequently, τx|u) since Pr (e, x, u) = Kxθx|u and Pr (e, x, u) = Kxθx|u, 3. If either of the previous parameters is zero, we can use the differential approach by Darwiche (2000) to compute the derivative directly.

$$\left(1\right)$$
$$c o n s t a n t\ \alpha_{\mathbf{e}}$$
