Example 2.1 **Consider again the network in Figure 3. Here, we set the evidence such that**
we have smoke, but no report of people evacuating the building, i.e. e = smoke, **report . We**
then got the posteriors Pr (fire | e) = .25 and Pr (tampering | e) = .02**. We thought in this**
case that the posterior on fire should be no less than .5 **and asked** SamIam **to recommend**
the necessary changes to enforce the constraint, Pr (fire | e) − Pr (fire | e) ≥ 0**. There were**
five recommendations in this case, three of which could be ruled out based on qualitative considerations:
1. increase the prior on fire to ≥ .03 **(from** .01); 2. increase the prior on tampering to ≥ .80 **(from** .02);
3. decrease Pr (smoke | fire) to ≤ .003 **(from** .01);

4. increase Pr (leaving | alarm) to ≥ .923 (from .001);
5. increase Pr (report | leaving) to ≥ .776 **(from** .01).

Clearly, the only sensible change here is either to increase **the prior on fire, or to decrease**
the probability of having smoke without a fire.

This example and other similar ones suggest that identifying such parameter changes and their magnitudes is inevitable for developing a faithful belief network, yet it is not trivial for experts to accomplish this task by visual inspection of the belief network, often due to its size and complexity. Sensitivity analysis tools such as SamIam **can help facilitate this**
by identifying important parameters that need to be fine-tuned **in order to satisfy certain**
constraints. Of course, if we are given multiple constraints, we need to be cautious when implementing a recommendation made by SamIam **due to one constraint, because this may**
result in violating other constraints. In this case, the parameter changes recommended by SamIam should be used to help experts in focusing their attention on **the relevant**
parameters.

Moreover, the previous examples illustrate the need to develop more analytic tools to understand and explain the sensitivity of queries to certain parameter changes. There is also a need to reconcile the sensitivities exhibited by our examples with previous experimental studies demonstrating the robustness of probabilistic **queries against small parameter**
changes in certain application areas, such as diagnosis (Pradhan et al., 1996). We address these particular questions in the next two sections.

## 3. The Sensitivity Of Probabilistic Queries To Parameters Changes

Our starting point in understanding the sensitivity of a query Pr (y | e**) to changes in a**
meta parameter τx|u is to analyze the derivative ∂Pr (y | e)/∂τx|u**. In our analysis, we**
assume that X is binary, but Y **and all other variables in the network can be multi-valued.**
The following theorem provides a simple bound on this derivative, in terms of Pr (y | e)
and Pr (x | u**) only. We then use this simple bound to study the effect of changes to meta**
parameters on probabilistic queries.