tion 3.2 presents an algorithm for updating the recognizer's beliefs about the agents' plan states upon the observation of a message. This algorithm performs the update with an efficiency gained by exploiting the particular semantics of communicated messages, namely that each such message is an observation that indicates the initiation/termination of a particular plan with certainty. Section 3.3 presents an algorithm for updating the recognizer's beliefs about the agents' plan states when no message has been observed. In the absence of any such evidence, this algorithm efficiently updates the recognizer's beliefs by using a temporal model of the agents' plan execution that makes a strong Markovian assumption.

Finally, Section 3.4 presents the overall recognition procedure, as well as an illustration and complexity analysis of that procedure.

## 3.1   Plan-State  Represent At Ion

We address uncertainty in monitoring through a probabilistic model that supports quantitative evaluation of the recognized plan hypotheses. Since we are monitoring these agents through the duration of their execution, we use a time series of plan-state variables. At each point in time, the agent's plan state is the state of the team-oriented program that it is currently executing, i.e., a path from root to leaf in the team-oriented program tree. We represent the plans in the program by a set of boolean random variables, { X t }, where each variable X t is true if and only if the agent is actively executing plan X at time t . We then represent our beliefs about the agent's actual state at time t as a probability distribution over all variables {X t} . The distribution takes into account dependencies among the different plans in the team-oriented program (e.g., parent-child relationships), as well as the temporal dependencies between the plan state at times t and t + 1. To simplify the dependency structure, it is useful to introduce additional boolean random variables, done ( X, t ), that are true if and only if plan X was executed at time t - 1 and its execution has terminated at time t There are a number of possible representations for capturing the distribution and performing inference over these variables. However, the generality of the plan hierarchy, the dynamic nature of the domain, and the requirements of the task eliminate most existing approaches from consideration. For instance, we could potentially generate a DBN —Dynamic Belief Network (Kjærulff, 1992)—to represent the probabilistic distribution over the plan variables. To do so, we include nodes representing all of the plan variables, X t , as well as representing done ( X, t ). The links among these nodes represent the structure of the plan herarchy (e.g., parent-child relationships, temporal constraints), and we can fill in the conditional probability tables accordingly. We also represent the temporal progress of the team by including nodes for the variables at the next time slice, X t+1 . We add links from the X t nodes to the X t +1 nodes and represent the dynamics in the conditional probability tables on those links. For each transition from a node X t to a node Y t +1 (X ̸ = Y), we would also add binary nodes indicating the observation of a message along that transition. Thus, for a plan hierarchy with M plan nodes, the corresponding DBN representation will have O(4M + M 2 ) = O(M 2 ) binary random variables.

The standard DBN inference algorithms maintain a belief state, bt, representing the posterior probability distribution over the variables in time slice, t, conditioned on all of the observations made so far (from time 0 ). These inference algorithms can update the