a successor has not yet begun (perhaps because the agent is in the process of sending a message). Thus, b t (X, block) is our belief that X has terminated, but the agent has not begun execution of a successor; b t ( X , ¬ block ) is then our belief at time t that the monitored agent is currently executing X, which has not yet terminated. More precisely, we define b t (X, block) ≡ Pr(X t, done(X, t + 1)| E ) and b t (X, ¬ Wock) ≡ Pr(X t, ¬ done(X, t + 1)| E ),
where E again denotes all of the evidence we have received so far. If the recognizer observes a message from an agent at time t , it updates its previous belief state, b t , by incorporating the evidence into its new belief state, b t +1, according to the method described in Section 3.2. If it does not observe a message from an agent at time t, it propagates belief into its new belief state, b t +1, using the method described in Section 3.3 to simulate plan execution over time.

## 3.2  Belief Update With Observed Message

While observing team communications, the recognizer can expect to occasionally receive evidence in the form of messages (sent by an individual agent member) that identify either plan initiation or termination. In incorporating this evidence, we exploit the assumption that the agents are truthful in their messages. In other words, if we observe an initiation message for a plan, X, at time t, then X, is true with certainty. Likewise, if we observe a termination message for a plan, X, at time t, then done ( X, t + 1) is true with certainty.

More precisely, the algorithms presented in this section are specialized to exploit the property of observed communications, where for any observation Ω, either Pr( X t | Ω, E ) = 1 or Pr(done(X, t)l Ω, E) = 1, for any possible previously observed evidence, E.

Though messages are assumed truthful, there still remains ambiguity.  First, while a message uniquely specifies the relevant plan, it does not uniquely specify the relevant node.

In other words, the recognizer is still unsure about which particular X t node the message refers to, since the graph may contain multiple X t nodes consistent with the message. Furthermore, when a message announces termination of a plan (even with no ambiguity about the corresponding node), there still remains ambiguity about the next plan selected by the agent.

The observations available in the overhearing tasks of immediate interest to us fall into this level of ambiguity. In our evacuation scenario example, there are two nodes corresponding to the plan land-troops, because there is one instance of land-troops for picking up the people to be transported and another for dropping them off. If the recognizer observes a message indicating that an agent has initiated execution of land-troops, then there is ambiguity about which of the two instances is currently relevant. Furthermore, there may exist ambiguity about which plan the agent will select after terminating land-troops .

Algorithm 1 presents the pseudo-code for the complete procedure for incorporating evidence from observations.

Incorporating Evidence of an Observed Initiation Message (lines 3–8)   Suppose that, at time t, we have observed a message, msg, that corresponds to initiation. If only one plan, X , is consistent with msg , then we know, with certainty, that the agent is executing X , regardless of whatever evidence we have previously observed. Therefore, we can simply set our belief that X t is true to be 1.0. If multiple plans are consistent with msg, we distribute the unit probability over each consistent plan, weighted by our prior belief in seeing the given