synthetic agent or human operator to monitor and identify the state of the distributed team.

Previous work has discussed the critical role of monitoring in visualization (e.g., Ndumu, Nwana, Lee, & Collis, 1999), in identifying failures in execution (e.g., Horling et  al., 2001), in providing advice to improve performance (e.g., Aiello, Busetta, Dona, & Serafini, 2001),
and in facilitating collaboration between the monitoring agent and the members of the team
(e.g., Grosz & Kraus, 1996).

This paper focuses on monitoring cooperative agent teams by overhearing their internal communications. This allows a human operator or a synthetic agent to monitor the coordinated execution of a task, by listening to the messages team-members exchange with each other. It contrasts with previous techniques that are impractical in settings where direct observations of the team members are unavailable (e.g., when team-members are physically distributed away from the observer), or in large-scale applications composed of already-deployed agents that are dynamically integrated to jointly execute a task.

For example, one common technique, report-based monitoring, requires each monitored team-member to communicate its state to the monitoring agent at regular intervals, or at least whenever the team-member changes its state. Such reporting provides the monitoring agent with accurate information on the state of the team.  Unfortunately, report-based monitoring suffers from several difficulties in monitoring large deployed teams of interest in the real-world (see Section 2 for a detailed discussion): First, it requires intrusive modifications to the behavior of agents, such that they report their state as needed by the different monitoring applications. However, since agents are already deployed, such repeated modifications to the behavior of the agents are difficult to implement and complex to manage. In particular, legacy and proprietary systems are notoriously expensive to modify (for instance, consider the notorious modifications to address the Year 2000 bug, also known as Y2K). Second, the bandwidth requirements of report-based monitoring (which relies on communication channels) can be unrealistic (Jennings, 1993, 1995; Grosz & Kraus, 1996; Pechoucek et  al., 2000, 2001; Vercouter, Beaune, & Sayettat, 2000). In addition, network delays and unreliable or lossy communication channels are a key concern with report-based monitoring aproaches.

We therefore advocate an alternative monitoring approach, based on multi-agent keyhole plan-recognition (Tambe, 1996; Huber & Hadley, 1997; Devaney & Ram, 1998; Intille &
Bobick, 1999; Kaminka & Tambe, 2000). In this approach, the monitoring system infers the unobservable state of the agents based on their observable actions, using knowledge of the plans that give rise to the actions. This approach is non-intrusive, requiring no changes to agents' behaviors; and it allows for changes in the requested monitoring information. It assumes access to knowledge of plans that may explain observable action—however this knowledge is readily available to the monitoring system as we assume it is deployed in a collaborative environment. Indeed, in some cases, the monitoring system may be deployed by the human operator of the team. An additional benefit of a plan-recognition approach is that it can rely on inference to compensate for occasional communication losses, and can therefore be robust to communication failures.

In general, the only observable actions of agents in a distributed team are their routine communications, which the agents exchange as part of task execution (Ndumu et  al., 1999).

Fortunately, the growing popularity of agent integration tools (Tambe, Pynadath, Chauvat, Das, & Kaminka, 2000; Martin, Cheyer, & Moran, 1999) and agent communications (Finin,