may be shorter than when communicating across continents. Indeed, latency times in the Internet vary greatly, and are difficult to predict.

G Plan execution times vary depending on when a plan-step is executed internally. For instance, the traveling plans, used repeatedly within the given evacuation teamoriented program, take anywhere from 15 seconds to almost two minutes to execute, depending on the particular route being followed.

- Plan execution times vary depending on the outcome of a plan-step. For instance, when the route-planner is functioning correctly, it responds within a few seconds. However, when it crashes it does not return an answer at all, and the other agents wait for a relatively long time before relying on a time-out to decide that it had failed.

This problem can be addressed in principle by a more expressive model of execution duration, for instance taking into account the internal execution context. However, in practice, such a model would likely be much more expensive computationally, as it would need to rely on knowledge of previous and future steps, breaking the Markovian assumption (e.g., to determine duration based on when a plan-step is executed , an improved temporal model would have to reason about the likelihood that a given instance of the plan-step is the second instance, as opposed to a third). As applications grow in scale in the real world, an increasingly more complex temporal model would have to be continuously refined to cover the increasingly complex temporal behavior of agents.  Fortunately, a temporal model is only one way in whi a monitoring system can estimate the times in whi agents change their internal state unobservedly.

An alternative method for estimating unobserved state changes is to utilize known dependencies between agents to exploit evidence about the state of one agent to infer the state of another. In particular, it is often true in team settings that one agent would send a messses the contract of the state of all its receivers in a particular way. Thus in principle, under the assumption that the receivers do change their state predictably, an observation of su a message can be used as evidence in the inference of the sender's state, as well as all receivers', i.e., the state of all team-members. We can trade the agent independence assumption made earlier with an assumption of successful coordination. This is a reasonable assumption in team settings, given that agents are actively attempting to maintain their teamwork with such communications (Tambe, 1997; Kumar et  al., 2000; Dunin-Keplicz &
Verbrugge, 2001).

The effects of a message on a receiver are dependent on the relationship between the sender and the receiver (where we take such a relationship to be described by a mathematical relation between the possible states of the sender and the receiver). In principle, such relationships underly social structures —structures of interactions between agents that make the decisions of one team-member dependent, to some predictable degree, on those of its teammates. Using knowledge of these dependencies, a monitoring agent may use observations of a communication action by an agent to infer the possible state of another.

One simple example of such a structure is common in many teams (e.g., Jennings, 1993; Kinny, Ljungberg, Rao, Sonenberg, Tidhar, & Werner, 1992), and indeed is present also in our application: roles that govern which team-members undertake what tasks in service