
## 4.3 Discussion

A key characteristic of monitoring by overhearing tasks is the scarcity of observations available to the monitoring system. Fortunately, the observations available to the monitoring stem can often be viewed as observations of multi-agent actions : The sender of the message not only changes its own state, but often also intends to change the state of the recipients (Cohen & Levesque, 1990).  Thus even a single observation can be used as evidence for inferring the state of both sender and receivers. This stands in contrast to previous work, which addressed monitoring of multiple single-agent actions.

In monitoring a team, the monitoring system can use knowledge of social structures and procedures to exploit information about the activities of one team-member, in hypothesizing about the activities of another team-member. These techniques are not specific to the representation presented earlier. For instance, an increased belief in one agent's execution of a plan X based on evidence for a teammate's execution of X can be also used by constructing appropriate probabilistic links between nodes representing these beliefs in a large D D N  representing the two agents. If we start with the DBN representation as discussed in Section 3.1, we can replicate the single-agent network (containing M plans) for each of the N separate agents. The number of nodes is then O ( M 2 N ), since we represent the plans and transitions for each individual agent. We can also introduce the appropriate inter-agent links to capture the inter-agent dependencies represented by our model of teamwork. However, upon introducing such links, the computational complexity of performing DBN inference explodes to O ( 2 M 2 N )
Obviously, such "social reasoning" can be computationally expensive, even with the efficient representation described earlier. The next section provides details of an efficient mechanism for reasoning about a team using information about role and coherence, and utilizing communications predictions. Using this mechanism, the techniques described in this section have resulted in an accuracy of up to 97% (84% average across all experiments)— compared to average 4% without the use of social knowledge. Sections 6.1 and 6.2 present a detailed discussion of these results.

## 5. Plan-Recognition For Overhearing

The previous section has outlined socially-attentive monitoring techniques, alleviating the uncertainty in monitoring a team of agents by exploiting knowledge of the social structures and social procedures of the monitored team. It discussed using coherence and role maintence to exploit knowledge of the ideal agreement of agents that specific plans be executed together, and that other specific plans are assigned to agents fulfilling their roles. Furthermore, it discussed disambiguation based on predictions of future observable behavior, based on knowledge of the social procedures employed by team-members. These disambiguation heuristics eliminate many (incorrect) hypotheses from being considered.  However, reasoning using these techniques can be computationally expensive.

This section presents an efficient algorithm, building on the representation previously presented, which facilitates scalable monitoring by overhearing of large teams. The key idea here is to represent only those hypotheses which the heuristics would have considered valid, eliminating from consideration plans and transitions that would be considered illegal with the heuristics. Relying on the team-hierarchy for bookeeping, all coherent hypotheses are