array approach, since multiple messages always cause multiple updates in the array, but in YOYO*, multiple messages may all refer to a single plan, thus triggering a single update. Incorporating evidence about initiated and terminated plans (lines 8–15).

For each one of these plans X in I (line 8), YOYO* now sets the new belief V , weighted by any prior belief in X's initiation (lines 10–11), similarly to how this is done in the INCORPORATE- EVIDENCE algorithm (Algorithm 1), but taking into account the team implied by the sender of the processed message (line 9). This is done by a lookup into M using the sender T (teammsg (mi)): Only transitions in M that T is allowed to take are followed. By definition, any transition that is allowed to be taken by a super-team of T is allowed for T . A similar process is then done with any termination messages (lines 12–15), but of course looking at possible successors of any plans consistent with the messages. However, since we do not want to cause updates in both line 11 and line 15 in cases where a termination message and an initiation message refer to the same transition, the loop over the plans Y (line 14) skips any plans which have already been addressed in the previous step.  Overall, the run-time complexity of this process is O ( M ).

Normalizing the temporary distribution V (line 16).  The temporary distribution / resulting from the processing of initiation and termination messages is normalized, in a similar fashion to the analogous step in algorithm 1. However, the process must take into account not only the plan-hierarchy in question, but also the team-hierarchy.  Unlike a typical normalization procedure, evidence for two different plans, selected by two different teams, may not necessarily compete with each other, and therefore may not necessarily require normalization. For instance, if two messages are observed, one implying that team A has initiated execution of plan P , and another implying that team B has initiated execution of plan Q , then if P and Q are both children of a joint parent J (executed jointly by the two subteams A , B ), then the same normalized likelihood (1.0) should be assigned to P and Q (and J —but this will be assigned to it by the propagation steps described below). The run-time complexity of this process is O ( M ). Propagating the evidence up and down M (lines 17–27).  First, the beliefs are set for each plan implied by the observations, and its children (lines 18–19). Then, the team T
that is to execute this plan is determined by a lookup into M using team ( X ) (line 20). Now YOYO* begins to propagate the evidence up to the plan's parents (lines 21–26). Any belief in the child plan is propagated and added to the belief in its parent (line 23). However, if the parent plan ( parent ( P )) is to be executed by a super-team of the current team T , then any change to its probability must be propagated to its other children, that are to be executed by other (subteams). Thus the upward propagation is alternated with downward propagation along hierarchical decomposition transitions 1 . This downward step is executed whenever the team that is responsible for joint execution of the parent plan is no longer the current subteam being considered ( T ), but its parent team in the team-hierarchy H i given by parentieam (T) (lines 24–26). When this condition is satisfied, any change in the beliefs about the parent plan must be propagated down to any children it has that are to be executed by other subteams. This is done via the SCALE algorithm (Algorithm 8, Appendix A).