from one application to the next, so does the information needed about each agent. Unfortunately, the agents and their proxies are already deployed in several government laboratories and universities. Modifying the agents at each deployed location is problematic and intrusive—modifications interfere with carefully designed timing specifications of given tasks, requiring further modifications by other agent developers. The distributed nature of TEAMCORE implies that there is no centralized server which controls the behavior of the agents, but instead changes are required in the different proxy types. Indeed, in general, modifying legacy and proprietary applications (including the integration architecture) is of course known to be a difficult process, and so a solution that requires constant modifications to the agents and architecture will not scale up.

A second important consideration was the computational and bandwidth requirements of report-based monitoring. As has been repeatedly noted in the literature, one cannot expect agents to be able to communicate continuously and fully monitor all other agents (e.g.,
Jennings, 1993, 1995; Grosz & Kraus, 1996; Pechoucek et  al., 2001; Vercouter et  al., 2000). In a team of 11 (used as an example in this paper), regularly scheduled state reports from the agents at the required temporal resolution would require approximately 50,000 messages to be sent during a 15-minute run, with the number nearly doubling when we reach 20 agents. If we instead have the 11 agents only report on state changes, announcing plan initiation and termination, approximately 2,000 messages have to be sent. However, this is still an order-of-magnitude more than the normal 100 messages or so that are exchanged by the 1 agents as part of routine execution. Even if the network could support the bandwidth nnecess ary for report-based monitoring, there is also a significant computational burden on the monitoring system to process all the incoming reports.

On the other hand, a plan-recognition approach seemed like a natural fit for the task.

First, it doesn't require any changes in the behavior of the monitored agents, and is thus very suitable for monitoring agents that are already deployed. Second, it doesn't add any computational burdens to the monitored agents or the network, since it uses only what observations are already available. Third, the main knowledge source plan-recognition systems typically rely on—a plan library—is in fact easily available in accessible form to the monitoring system from the team-oriented program which is used to integrate the agents, since the operator deploying the monitoring system is assumed to be the one to describe the integration team-oriented program in the first place. Thus plan-recognition's sometimes criticized assumption of a correct plan-library is in fact satisfied fully in this monitoring applic ation.

Note that this assumption holds even if agents are not all using the same integration aritecture: The only knowledge we rely on is a (possibly stochastic) model of how components of execution fit together, and the communications that are used to integrate them. Therefore, while this paper focuses on team-oriented programs (described above), the techniques introduced appear generalizable to other types of representation languages for distributed systems, such as TÆMS (Decker, 1995), team-oriented programming (Tidhar, 1993a) and others. Furthermore, the plan-library need not contain implemetation detailsonly the names of the key steps. Thus even agents utilizing radically-different represent ations than a plan-hierarchy can be monitored, as long as they have execution states corresponding to the team-oriented program (which they have to have in any case in order to coordinate with other team-members).